/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.transport.Transport;

public class PixelFormat {
    public byte bitsPerPixel;
    public byte depth;
    public byte bigEndianFlag;
    public byte trueColourFlag;
    public short redMax;
    public short greenMax;
    public short blueMax;
    public byte redShift;
    public byte greenShift;
    public byte blueShift;

    public void fill(Transport transport) throws TransportException {
        this.bitsPerPixel = transport.readByte();
        this.depth = transport.readByte();
        this.bigEndianFlag = transport.readByte();
        this.trueColourFlag = transport.readByte();
        this.redMax = transport.readInt16();
        this.greenMax = transport.readInt16();
        this.blueMax = transport.readInt16();
        this.redShift = transport.readByte();
        this.greenShift = transport.readByte();
        this.blueShift = transport.readByte();
        transport.readBytes(3);
    }

    public void send(Transport transport) throws TransportException {
        transport.write(this.bitsPerPixel).write(this.depth).write(this.bigEndianFlag).write(this.trueColourFlag).write(this.redMax).write(this.greenMax).write(this.blueMax).write(this.redShift).write(this.greenShift).write(this.blueShift).writeInt16(0).writeByte(0);
    }

    public static PixelFormat create24bitColorDepthPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)32;
        pixelFormat.blueMax = (short)255;
        pixelFormat.blueShift = 0;
        pixelFormat.greenMax = (short)255;
        pixelFormat.greenShift = (byte)8;
        pixelFormat.redMax = (short)255;
        pixelFormat.redShift = (byte)16;
        pixelFormat.depth = (byte)24;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public static PixelFormat create16bitColorDepthPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)16;
        pixelFormat.blueMax = (short)31;
        pixelFormat.blueShift = 0;
        pixelFormat.greenMax = (short)63;
        pixelFormat.greenShift = (byte)5;
        pixelFormat.redMax = (short)31;
        pixelFormat.redShift = (byte)11;
        pixelFormat.depth = (byte)16;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public static PixelFormat create8bitColorDepthBGRPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)8;
        pixelFormat.redMax = (short)7;
        pixelFormat.redShift = 0;
        pixelFormat.greenMax = (short)7;
        pixelFormat.greenShift = (byte)3;
        pixelFormat.blueMax = (short)3;
        pixelFormat.blueShift = (byte)6;
        pixelFormat.depth = (byte)8;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public static PixelFormat create6bitColorDepthPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)8;
        pixelFormat.blueMax = (short)3;
        pixelFormat.blueShift = 0;
        pixelFormat.greenMax = (short)3;
        pixelFormat.greenShift = (byte)2;
        pixelFormat.redMax = (short)3;
        pixelFormat.redShift = (byte)4;
        pixelFormat.depth = (byte)6;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public static PixelFormat create3bitColorDepthPixelFormat(int bigEndianFlag) {
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.bigEndianFlag = (byte)bigEndianFlag;
        pixelFormat.bitsPerPixel = (byte)8;
        pixelFormat.blueMax = 1;
        pixelFormat.blueShift = 0;
        pixelFormat.greenMax = 1;
        pixelFormat.greenShift = 1;
        pixelFormat.redMax = 1;
        pixelFormat.redShift = (byte)2;
        pixelFormat.depth = (byte)3;
        pixelFormat.trueColourFlag = 1;
        return pixelFormat;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(0xFF & this.bitsPerPixel));
        String string2 = String.valueOf(String.valueOf(0xFF & this.depth));
        String string3 = String.valueOf(String.valueOf(0xFF & this.bigEndianFlag));
        String string4 = String.valueOf(String.valueOf(0xFF & this.trueColourFlag));
        String string5 = String.valueOf(String.valueOf(0xFFFF & this.redMax));
        String string6 = String.valueOf(String.valueOf(0xFFFF & this.greenMax));
        String string7 = String.valueOf(String.valueOf(0xFFFF & this.blueMax));
        String string8 = String.valueOf(String.valueOf(0xFF & this.redShift));
        String string9 = String.valueOf(String.valueOf(0xFF & this.greenShift));
        String string10 = String.valueOf(String.valueOf(0xFF & this.blueShift));
        return new StringBuilder(156 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length() + String.valueOf(string9).length() + String.valueOf(string10).length()).append("PixelFormat: [bits-per-pixel: ").append(string).append(", depth: ").append(string2).append(", big-endian-flag: ").append(string3).append(", true-color-flag: ").append(string4).append(", red-max: ").append(string5).append(", green-max: ").append(string6).append(", blue-max: ").append(string7).append(", red-shift: ").append(string8).append(", green-shift: ").append(string9).append(", blue-shift: ").append(string10).append("]").toString();
    }
}

