/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.gradle.internal.UncheckedException;
import org.gradle.play.internal.run.PlayAppLifecycleUpdate;
import org.gradle.play.internal.run.PlayRunWorkerClientProtocol;

public class PlayWorkerClient
implements PlayRunWorkerClientProtocol {
    private final BlockingQueue<PlayAppLifecycleUpdate> startEvent = new SynchronousQueue<PlayAppLifecycleUpdate>();
    private final BlockingQueue<PlayAppLifecycleUpdate> stopEvent = new SynchronousQueue<PlayAppLifecycleUpdate>();

    public void update(PlayAppLifecycleUpdate update) {
        try {
            if (update.isStopped()) {
                this.stopEvent.put(update);
            } else {
                this.startEvent.put(update);
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public PlayAppLifecycleUpdate waitForRunning() {
        try {
            return this.startEvent.take();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public PlayAppLifecycleUpdate waitForStop() {
        try {
            return this.stopEvent.take();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

