/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.internal.reflect.ClassDetails;
import org.gradle.internal.reflect.NoSuchPropertyException;
import org.gradle.internal.reflect.PropertyDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInspector {
    public static ClassDetails inspect(Class<?> type) {
        DefaultClassDetails classDetails = new DefaultClassDetails(type);
        ClassInspector.visitGraph(type, classDetails);
        return classDetails;
    }

    private static void visitGraph(Class<?> type, DefaultClassDetails classDetails) {
        HashSet<Class> seen = new HashSet<Class>();
        ArrayList queue = new ArrayList();
        queue.add(type);
        while (!queue.isEmpty()) {
            Class current = (Class)queue.remove(0);
            if (!seen.add(current)) continue;
            ClassInspector.inspectClass(current, classDetails);
            for (Class<?> c : current.getInterfaces()) {
                queue.add(0, c);
            }
            if (current.getSuperclass() == null || current.getSuperclass() == Object.class) continue;
            queue.add(0, current.getSuperclass());
        }
    }

    private static void inspectClass(Class<?> type, DefaultClassDetails classDetails) {
        for (Method method : type.getDeclaredMethods()) {
            String propertyName;
            classDetails.method(method);
            if (Modifier.isPrivate(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isBridge()) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            String methodName = method.getName();
            if (methodName.startsWith("get") && methodName.length() > 3 && !method.getReturnType().equals(Void.TYPE) && parameterTypes.length == 0) {
                propertyName = ClassInspector.propertyName(methodName, 3);
                classDetails.property(propertyName).addGetter(method);
                continue;
            }
            if (methodName.startsWith("is") && methodName.length() > 2 && (method.getReturnType().equals(Boolean.class) || method.getReturnType().equals(Boolean.TYPE)) && parameterTypes.length == 0) {
                propertyName = ClassInspector.propertyName(methodName, 2);
                classDetails.property(propertyName).addGetter(method);
                continue;
            }
            if (methodName.startsWith("set") && methodName.length() > 3 && parameterTypes.length == 1) {
                propertyName = ClassInspector.propertyName(methodName, 3);
                classDetails.property(propertyName).addSetter(method);
                continue;
            }
            classDetails.instanceMethod(method);
        }
    }

    private static String propertyName(String methodName, int beginIndex) {
        String propertyName = methodName.substring(beginIndex);
        if (Character.isUpperCase(propertyName.charAt(0)) && propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1))) {
            return propertyName;
        }
        return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPropertyDetails
    implements PropertyDetails {
        private final String name;
        private final MethodSet getters = new MethodSet();
        private final MethodSet setters = new MethodSet();

        private DefaultPropertyDetails(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<Method> getGetters() {
            return this.getters.getValues();
        }

        @Override
        public List<Method> getSetters() {
            return this.setters.getValues();
        }

        public void addGetter(Method method) {
            this.getters.add(method);
        }

        public void addSetter(Method method) {
            this.setters.add(method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultClassDetails
    implements ClassDetails {
        private final Class<?> type;
        private final MethodSet instanceMethods = new MethodSet();
        private final Map<String, DefaultPropertyDetails> properties = new TreeMap<String, DefaultPropertyDetails>();
        private final List<Method> methods = new ArrayList<Method>();

        private DefaultClassDetails(Class<?> type) {
            this.type = type;
        }

        @Override
        public List<Method> getAllMethods() {
            return this.methods;
        }

        @Override
        public List<Method> getInstanceMethods() {
            return this.instanceMethods.getValues();
        }

        @Override
        public Set<String> getPropertyNames() {
            return this.properties.keySet();
        }

        @Override
        public Collection<? extends PropertyDetails> getProperties() {
            return this.properties.values();
        }

        @Override
        public PropertyDetails getProperty(String name) throws NoSuchPropertyException {
            DefaultPropertyDetails property = this.properties.get(name);
            if (property == null) {
                throw new NoSuchPropertyException(String.format("No property '%s' found on %s.", name, this.type));
            }
            return property;
        }

        public void method(Method method) {
            this.methods.add(method);
        }

        public void instanceMethod(Method method) {
            this.instanceMethods.add(method);
        }

        public DefaultPropertyDetails property(String propertyName) {
            DefaultPropertyDetails property = this.properties.get(propertyName);
            if (property == null) {
                property = new DefaultPropertyDetails(propertyName);
                this.properties.put(propertyName, property);
            }
            return property;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodSet
    implements Iterable<Method> {
        private final Set<MethodSignature> signatures = new HashSet<MethodSignature>();
        private final List<Method> methods = new ArrayList<Method>();

        private MethodSet() {
        }

        public boolean add(Method method) {
            MethodSignature methodSignature = new MethodSignature(method.getName(), method.getParameterTypes());
            if (this.signatures.add(methodSignature)) {
                this.methods.add(method);
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Method> iterator() {
            return this.methods.iterator();
        }

        public List<Method> getValues() {
            return this.methods;
        }

        public boolean isEmpty() {
            return this.methods.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodSignature {
        final String name;
        final Class<?>[] params;

        private MethodSignature(String name, Class<?>[] params) {
            this.name = name;
            this.params = params;
        }

        public boolean equals(Object obj) {
            MethodSignature other = (MethodSignature)obj;
            return other.name.equals(this.name) && Arrays.equals(this.params, other.params);
        }

        public int hashCode() {
            return this.name.hashCode() ^ Arrays.hashCode(this.params);
        }
    }
}

