/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal.findbugs;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.TextUICommandLine;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsResult;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpec;

public class FindBugsExecuter
implements Serializable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FindBugsResult runFindbugs(FindBugsSpec spec) throws IOException, InterruptedException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            List<String> args = spec.getArguments();
            String[] strArray = new String[args.size()];
            args.toArray(strArray);
            Thread.currentThread().setContextClassLoader(FindBugs2.class.getClassLoader());
            FindBugs2 findBugs2 = new FindBugs2();
            TextUICommandLine commandLine = new TextUICommandLine();
            FindBugs.processCommandLine((TextUICommandLine)commandLine, (String[])strArray, (IFindBugsEngine)findBugs2);
            findBugs2.execute();
            FindBugsResult findBugsResult = this.createFindbugsResult((IFindBugsEngine)findBugs2);
            return findBugsResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    FindBugsResult createFindbugsResult(IFindBugsEngine findBugs) {
        int bugCount = findBugs.getBugCount();
        int missingClassCount = findBugs.getMissingClassCount();
        int errorCount = findBugs.getErrorCount();
        return new FindBugsResult(bugCount, missingClassCount, errorCount);
    }
}

