/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import java.io.File;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ChangesAfterPathComparator
implements Comparator<Change> {
    private static final ChangesAfterPathComparator ourInstance = new ChangesAfterPathComparator();
    private static final Comparator<ContentRevision> ourComparator = new Comparator<ContentRevision>(){

        @Override
        public int compare(@NotNull ContentRevision o1, @NotNull ContentRevision o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/idea/svn/rollback/ChangesAfterPathComparator$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/idea/svn/rollback/ChangesAfterPathComparator$1", "compare"));
            }
            return FileUtil.compareFiles((File)o1.getFile().getIOFile(), (File)o2.getFile().getIOFile());
        }
    };

    public static ChangesAfterPathComparator getInstance() {
        return ourInstance;
    }

    @Override
    public int compare(Change o1, Change o2) {
        ContentRevision ar1 = o1.getAfterRevision();
        ContentRevision ar2 = o2.getAfterRevision();
        return Comparing.compare((Object)ar1, (Object)ar2, ourComparator);
    }
}

