/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class DefaultBranchConfigInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(DefaultBranchConfigInitializer.class);
    @NonNls
    private static final String DEFAULT_TRUNK_NAME = "trunk";
    @NonNls
    private static final String DEFAULT_BRANCHES_NAME = "branches";
    @NonNls
    private static final String DEFAULT_TAGS_NAME = "tags";
    @NotNull
    private final Project myProject;
    @NotNull
    private final NewRootBunch myBunch;
    @NotNull
    private final VirtualFile myRoot;

    public DefaultBranchConfigInitializer(@NotNull Project project, @NotNull NewRootBunch bunch, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "<init>"));
        }
        if (bunch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bunch", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "<init>"));
        }
        this.myProject = project;
        this.myRoot = root;
        this.myBunch = bunch;
    }

    @Override
    public void run() {
        SvnBranchConfigurationNew configuration = this.getDefaultConfiguration();
        if (configuration != null) {
            for (String url : configuration.getBranchUrls()) {
                this.myBunch.reloadBranchesAsync(this.myRoot, url, InfoReliability.defaultValues);
            }
            this.myBunch.updateForRoot(this.myRoot, new InfoStorage<SvnBranchConfigurationNew>(configuration, InfoReliability.defaultValues), false);
        }
    }

    @Nullable
    public SvnBranchConfigurationNew getDefaultConfiguration() {
        SvnBranchConfigurationNew result = null;
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        SVNURL rootUrl = SvnUtil.getUrl(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myRoot));
        if (rootUrl != null) {
            try {
                result = DefaultBranchConfigInitializer.getDefaultConfiguration(vcs, rootUrl);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            LOG.info("Directory is not a working copy: " + this.myRoot.getPresentableUrl());
        }
        return result;
    }

    @NotNull
    private static SvnBranchConfigurationNew getDefaultConfiguration(@NotNull SvnVcs vcs, @NotNull SVNURL url) throws SVNException, VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "getDefaultConfiguration"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "getDefaultConfiguration"));
        }
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.setTrunkUrl(url.toString());
        SVNURL branchLocationsParent = DefaultBranchConfigInitializer.getBranchLocationsParent(url);
        if (branchLocationsParent != null) {
            SvnTarget target = SvnTarget.fromURL((SVNURL)branchLocationsParent);
            vcs.getFactory(target).createBrowseClient().list(target, SVNRevision.HEAD, Depth.IMMEDIATES, DefaultBranchConfigInitializer.createHandler(result, target.getURL()));
        }
        SvnBranchConfigurationNew svnBranchConfigurationNew = result;
        if (svnBranchConfigurationNew == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "getDefaultConfiguration"));
        }
        return svnBranchConfigurationNew;
    }

    @Nullable
    private static SVNURL getBranchLocationsParent(@NotNull SVNURL url) throws SVNException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "getBranchLocationsParent"));
        }
        while (!DefaultBranchConfigInitializer.hasEmptyName(url) && !DefaultBranchConfigInitializer.hasDefaultName(url)) {
            url = url.removePathTail();
        }
        return DefaultBranchConfigInitializer.hasDefaultName(url) ? url.removePathTail() : null;
    }

    private static boolean hasEmptyName(@NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "hasEmptyName"));
        }
        return StringUtil.isEmpty((String)SVNPathUtil.tail((String)url.getPath()));
    }

    private static boolean hasDefaultName(@NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "hasDefaultName"));
        }
        String name = SVNPathUtil.tail((String)url.getPath());
        return name.equalsIgnoreCase(DEFAULT_TRUNK_NAME) || name.equalsIgnoreCase(DEFAULT_BRANCHES_NAME) || name.equalsIgnoreCase(DEFAULT_TAGS_NAME);
    }

    @NotNull
    private static DirectoryEntryConsumer createHandler(final @NotNull SvnBranchConfigurationNew result, final @NotNull SVNURL rootPath) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "createHandler"));
        }
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "createHandler"));
        }
        DirectoryEntryConsumer directoryEntryConsumer = new DirectoryEntryConsumer(){

            public void consume(DirectoryEntry entry) throws SVNException {
                if (entry.isDirectory()) {
                    SVNURL childUrl = rootPath.appendPath(entry.getName(), false);
                    if (StringUtil.endsWithIgnoreCase((String)entry.getName(), (String)DefaultBranchConfigInitializer.DEFAULT_TRUNK_NAME)) {
                        result.setTrunkUrl(childUrl.toString());
                    } else {
                        result.addBranches(childUrl.toString(), new InfoStorage<List<SvnBranchItem>>(new ArrayList(0), InfoReliability.defaultValues));
                    }
                }
            }
        };
        if (directoryEntryConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer", "createHandler"));
        }
        return directoryEntryConsumer;
    }
}

