/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.testkit.jarjar.org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.converters.TaskPropertyHandlerFactory;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelBuilder;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBuilderBackedModelProducer
implements ModelProducer {
    private final ProtocolToModelAdapter adapter;
    private final VersionDetails versionDetails;
    private final ModelMapping modelMapping;
    private final ModelBuilder builder;
    private final Action<SourceObjectMapping> mapper;

    public ModelBuilderBackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, ModelBuilder builder) {
        this.adapter = adapter;
        this.versionDetails = versionDetails;
        this.modelMapping = modelMapping;
        this.builder = builder;
        this.mapper = new TaskPropertyHandlerFactory().forVersion(versionDetails);
    }

    @Override
    public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
        BuildResult<?> result;
        if (!this.versionDetails.maySupportModel(type)) {
            throw Exceptions.unsupportedModel(type, this.versionDetails.getVersion());
        }
        ModelIdentifier modelIdentifier = this.modelMapping.getModelIdentifierFromModelType(type);
        try {
            result = this.builder.getModel(modelIdentifier, operationParameters);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(type, e);
        }
        return this.adapter.adapt(type, result.getModel(), this.mapper);
    }
}

