/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.groovy.scripts;

import java.io.File;
import java.net.URI;
import org.gradle.testkit.jarjar.org.gradle.groovy.scripts.AbstractUriScriptSource;
import org.gradle.testkit.jarjar.org.gradle.groovy.scripts.NonExistentFileScriptSource;
import org.gradle.testkit.jarjar.org.gradle.groovy.scripts.ScriptSource;
import org.gradle.testkit.jarjar.org.gradle.internal.resource.Resource;
import org.gradle.testkit.jarjar.org.gradle.internal.resource.UriResource;

public class UriScriptSource
extends AbstractUriScriptSource {
    private final Resource resource;

    public static ScriptSource file(String description, File sourceFile) {
        if (sourceFile.exists()) {
            return new UriScriptSource(description, sourceFile);
        }
        return new NonExistentFileScriptSource(description, sourceFile);
    }

    public UriScriptSource(String description, File sourceFile) {
        this.resource = new UriResource(description, sourceFile);
    }

    public UriScriptSource(String description, URI sourceUri) {
        this.resource = new UriResource(description, sourceUri);
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getFileName() {
        File sourceFile = this.resource.getFile();
        URI sourceUri = this.resource.getURI();
        return sourceFile != null ? sourceFile.getPath() : sourceUri.toString();
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }
}

