/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.compiler;

import com.google.gson.Gson;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import groovy.lang.GroovyObject;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.taskdefs.Ant;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerFactory;

public class GradleBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project myProject;
    private List<String> myClasspath;

    public GradleBuildProcessParametersProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/compiler/GradleBuildProcessParametersProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public List<String> getClassPath() {
        if (this.myClasspath == null) {
            this.myClasspath = ContainerUtil.newArrayList();
            GradleBuildProcessParametersProvider.addGradleClassPath(this.myClasspath);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            for (Module module : moduleManager.getModules()) {
                if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
                GradleBuildProcessParametersProvider.addOtherClassPath(this.myClasspath);
                break;
            }
        }
        List<String> list = this.myClasspath;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/compiler/GradleBuildProcessParametersProvider", "getClassPath"));
        }
        return list;
    }

    private static void addGradleClassPath(@NotNull List<String> classpath) {
        File[] children;
        if (classpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classpath", "org/jetbrains/plugins/gradle/compiler/GradleBuildProcessParametersProvider", "addGradleClassPath"));
        }
        String gradleLibDirPath = null;
        String gradleToolingApiJarPath = PathUtil.getJarPathForClass(ProjectConnection.class);
        if (!StringUtil.isEmpty((String)gradleToolingApiJarPath)) {
            gradleLibDirPath = PathUtil.getParentPath((String)gradleToolingApiJarPath);
        }
        if (gradleLibDirPath == null || gradleLibDirPath.isEmpty()) {
            return;
        }
        File gradleLibDir = new File(gradleLibDirPath);
        if (!gradleLibDir.isDirectory()) {
            return;
        }
        for (File child : children = FileUtil.notNullize((File[])gradleLibDir.listFiles())) {
            String fileName = child.getName();
            if (!fileName.endsWith(".jar") || !child.isFile()) continue;
            classpath.add(child.getAbsolutePath());
        }
    }

    private static void addOtherClassPath(@NotNull List<String> classpath) {
        if (classpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classpath", "org/jetbrains/plugins/gradle/compiler/GradleBuildProcessParametersProvider", "addOtherClassPath"));
        }
        classpath.add(PathUtil.getJarPathForClass(Ant.class));
        classpath.add(PathUtil.getJarPathForClass(GroovyObject.class));
        classpath.add(PathUtil.getJarPathForClass(Gson.class));
        classpath.add(PathUtil.getJarPathForClass(Logger.class));
        classpath.add(PathUtil.getJarPathForClass(Log4jLoggerFactory.class));
    }
}

