/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.KeyValue;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginAction;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;

class AddGradleDslPluginActionHandler
implements CodeInsightActionHandler {
    private final KeyValue[] myPlugins;

    public AddGradleDslPluginActionHandler(KeyValue[] plugins) {
        this.myPlugins = plugins;
    }

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginActionHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginActionHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginActionHandler", "invoke"));
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite((Editor)editor)) {
            return;
        }
        final JBList list = new JBList((Object[])this.myPlugins);
        list.setSelectionMode(0);
        list.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final KeyValue selected = (KeyValue)list.getSelectedValue();
                new WriteCommandAction.Simple(project, GradleBundle.message("gradle.codeInsight.action.apply_plugin.text", new Object[0]), new PsiFile[]{file}){

                    protected void run() {
                        if (selected == null) {
                            return;
                        }
                        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
                        GrStatement grStatement = factory.createStatementFromText((CharSequence)String.format("apply plugin: '%s'", selected.getKey()), null);
                        PsiElement anchor = file.findElementAt(editor.getCaretModel().getOffset());
                        PsiElement currentElement = PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{GrClosableBlock.class, GroovyFile.class});
                        if (currentElement != null) {
                            currentElement.addAfter((PsiElement)grStatement, anchor);
                        } else {
                            file.addAfter((PsiElement)grStatement, file.findElementAt(editor.getCaretModel().getOffset() - 1));
                        }
                        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                        Document document = documentManager.getDocument(file);
                        if (document != null) {
                            documentManager.commitDocument(document);
                        }
                    }
                }.execute();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            KeyValue descriptor = (KeyValue)ContainerUtil.find((Object[])this.myPlugins, (Condition)new Condition<KeyValue>(){

                public boolean value(KeyValue value) {
                    return value.getKey().equals(AddGradleDslPluginAction.TEST_THREAD_LOCAL.get());
                }
            });
            list.setSelectedValue((Object)descriptor, false);
            runnable.run();
        } else {
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(GradleBundle.message("gradle.codeInsight.action.apply_plugin.popup.title", new Object[0])).setItemChoosenCallback(runnable).setFilteringEnabled((Function)new Function<Object, String>(){

                public String fun(Object o) {
                    return String.valueOf(((KeyValue)o).getKey());
                }
            }).createPopup().showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myNameLabel;
        private final JLabel myDescLabel;

        public MyListCellRenderer() {
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.myNameLabel = new JLabel();
            this.myPanel.add((Component)this.myNameLabel, "West");
            this.myPanel.add(new JLabel("     "));
            this.myDescLabel = new JLabel();
            this.myPanel.add((Component)this.myDescLabel, "East");
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            Font font = scheme.getFont(EditorFontType.PLAIN);
            this.myNameLabel.setFont(font);
            this.myDescLabel.setFont(font);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            KeyValue descriptor = (KeyValue)value;
            Color backgroundColor = isSelected ? list.getSelectionBackground() : list.getBackground();
            this.myNameLabel.setText(String.valueOf(descriptor.getKey()));
            this.myNameLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.myPanel.setBackground(backgroundColor);
            String description = String.format("<html><div WIDTH=%d>%s</div><html>", 400, String.valueOf(descriptor.getValue()));
            this.myDescLabel.setText(description);
            this.myDescLabel.setForeground(LookupCellRenderer.getGrayedForeground((boolean)isSelected));
            this.myDescLabel.setBackground(backgroundColor);
            return this.myPanel;
        }
    }
}

