/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.DefaultPolymorphicDomainObjectContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.UnavailablePlatformToolProvider;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNativeToolChainRegistry
extends DefaultPolymorphicDomainObjectContainer<NativeToolChain>
implements NativeToolChainRegistryInternal {
    private final Map<String, Class<? extends NativeToolChain>> registeredDefaults = new LinkedHashMap<String, Class<? extends NativeToolChain>>();
    private final List<NativeToolChainInternal> searchOrder = new ArrayList<NativeToolChainInternal>();

    public DefaultNativeToolChainRegistry(Instantiator instantiator) {
        super(NativeToolChain.class, instantiator);
        this.whenObjectAdded((Action)new Action<NativeToolChain>(){

            public void execute(NativeToolChain toolChain) {
                DefaultNativeToolChainRegistry.this.searchOrder.add((NativeToolChainInternal)toolChain);
            }
        });
        this.whenObjectRemoved((Action)new Action<NativeToolChain>(){

            public void execute(NativeToolChain toolChain) {
                DefaultNativeToolChainRegistry.this.searchOrder.remove(toolChain);
            }
        });
    }

    protected void handleAttemptToAddItemWithNonUniqueName(NativeToolChain toolChain) {
        throw new InvalidUserDataException(String.format("ToolChain with name '%s' added multiple times", toolChain.getName()));
    }

    @Override
    public void registerDefaultToolChain(String name, Class<? extends NativeToolChain> type) {
        this.registeredDefaults.put(name, type);
    }

    @Override
    public void addDefaultToolChains() {
        for (String name : this.registeredDefaults.keySet()) {
            this.create(name, this.registeredDefaults.get(name));
        }
    }

    public NativeToolChain getForPlatform(NativePlatform targetPlatform) {
        for (NativeToolChainInternal toolChain : this.searchOrder) {
            if (!toolChain.select((NativePlatformInternal)targetPlatform).isAvailable()) continue;
            return toolChain;
        }
        LinkedHashMap<String, PlatformToolProvider> candidates = new LinkedHashMap<String, PlatformToolProvider>();
        for (NativeToolChainInternal toolChain : this.searchOrder) {
            candidates.put(toolChain.getDisplayName(), toolChain.select((NativePlatformInternal)targetPlatform));
        }
        return new UnavailableNativeToolChain(new UnavailableToolChainDescription(targetPlatform, candidates));
    }

    private static class UnavailableNativeToolChain
    implements NativeToolChainInternal {
        private final ToolSearchResult failure;

        UnavailableNativeToolChain(ToolSearchResult failure) {
            this.failure = failure;
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return "unavailable";
        }

        public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), this.failure);
        }

        public String getOutputType() {
            return "unavailable";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnavailableToolChainDescription
    implements ToolSearchResult {
        private final NativePlatform targetPlatform;
        private final Map<String, PlatformToolProvider> candidates;

        private UnavailableToolChainDescription(NativePlatform targetPlatform, Map<String, PlatformToolProvider> candidates) {
            this.targetPlatform = targetPlatform;
            this.candidates = candidates;
        }

        public boolean isAvailable() {
            return false;
        }

        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)String.format("No tool chain is available to build for platform '%s'", this.targetPlatform.getName()));
            visitor.startChildren();
            for (Map.Entry<String, PlatformToolProvider> entry : this.candidates.entrySet()) {
                visitor.node((Object)entry.getKey());
                visitor.startChildren();
                entry.getValue().explain(visitor);
                visitor.endChildren();
            }
            if (this.candidates.isEmpty()) {
                visitor.node((Object)"No tool chain plugin applied.");
            }
            visitor.endChildren();
        }
    }
}

