/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubGist {
    @NotNull
    private final String myId;
    @NotNull
    private final String myDescription;
    private final boolean myIsPublic;
    @NotNull
    private final String myHtmlUrl;
    @NotNull
    private final List<GistFile> myFiles;
    @Nullable
    private final GithubUser myUser;

    @NotNull
    public List<FileContent> getContent() {
        ArrayList<FileContent> ret = new ArrayList<FileContent>();
        for (GistFile file : this.getFiles()) {
            ret.add(new FileContent(file.getFilename(), file.getContent()));
        }
        ArrayList<FileContent> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist", "getContent"));
        }
        return arrayList;
    }

    public GithubGist(@NotNull String id, @Nullable String description, boolean isPublic, @NotNull String htmlUrl, @NotNull List<GistFile> files, @Nullable GithubUser user) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/github/api/GithubGist", "<init>"));
        }
        if (htmlUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlUrl", "org/jetbrains/plugins/github/api/GithubGist", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/plugins/github/api/GithubGist", "<init>"));
        }
        this.myId = id;
        this.myDescription = StringUtil.notNullize((String)description);
        this.myIsPublic = isPublic;
        this.myHtmlUrl = htmlUrl;
        this.myFiles = files;
        this.myUser = user;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist", "getId"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist", "getDescription"));
        }
        return string;
    }

    public boolean isPublic() {
        return this.myIsPublic;
    }

    @NotNull
    public String getHtmlUrl() {
        String string = this.myHtmlUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist", "getHtmlUrl"));
        }
        return string;
    }

    @NotNull
    public List<GistFile> getFiles() {
        List<GistFile> list = this.myFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist", "getFiles"));
        }
        return list;
    }

    @Nullable
    public GithubUser getUser() {
        return this.myUser;
    }

    public static class FileContent {
        @NotNull
        private final String myFileName;
        @NotNull
        private final String myContent;

        public FileContent(@NotNull String fileName, @NotNull String content) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/plugins/github/api/GithubGist$FileContent", "<init>"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/github/api/GithubGist$FileContent", "<init>"));
            }
            this.myFileName = fileName;
            this.myContent = content;
        }

        @NotNull
        public String getFileName() {
            String string = this.myFileName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist$FileContent", "getFileName"));
            }
            return string;
        }

        @NotNull
        public String getContent() {
            String string = this.myContent;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist$FileContent", "getContent"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileContent that = (FileContent)o;
            if (!this.myContent.equals(that.myContent)) {
                return false;
            }
            return this.myFileName.equals(that.myFileName);
        }

        public int hashCode() {
            int result = this.myFileName.hashCode();
            result = 31 * result + this.myContent.hashCode();
            return result;
        }
    }

    public static class GistFile {
        @NotNull
        private final String myFilename;
        @NotNull
        private final String myContent;
        @NotNull
        private final String myRawUrl;

        public GistFile(@NotNull String filename, @NotNull String content, @NotNull String rawUrl) {
            if (filename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "org/jetbrains/plugins/github/api/GithubGist$GistFile", "<init>"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/github/api/GithubGist$GistFile", "<init>"));
            }
            if (rawUrl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawUrl", "org/jetbrains/plugins/github/api/GithubGist$GistFile", "<init>"));
            }
            this.myFilename = filename;
            this.myContent = content;
            this.myRawUrl = rawUrl;
        }

        @NotNull
        public String getFilename() {
            String string = this.myFilename;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist$GistFile", "getFilename"));
            }
            return string;
        }

        @NotNull
        public String getContent() {
            String string = this.myContent;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist$GistFile", "getContent"));
            }
            return string;
        }

        @NotNull
        public String getRawUrl() {
            String string = this.myRawUrl;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubGist$GistFile", "getRawUrl"));
            }
            return string;
        }
    }
}

