/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;

public class LineNumberTableAttribute
extends Attribute {
    public int u2lineNumberTableLength;
    public LineNumberInfo[] lineNumberTable;

    public LineNumberTableAttribute() {
    }

    public LineNumberTableAttribute(int u2attributeNameIndex, int u2lineNumberTableLength, LineNumberInfo[] lineNumberTable) {
        super(u2attributeNameIndex);
        this.u2lineNumberTableLength = u2lineNumberTableLength;
        this.lineNumberTable = lineNumberTable;
    }

    public int getLineNumber(int pc) {
        LineNumberInfo info = this.getLineNumberInfo(pc);
        return info == null ? 0 : info.u2lineNumber;
    }

    public String getSource(int pc) {
        LineNumberInfo info = this.getLineNumberInfo(pc);
        return info == null ? null : info.getSource();
    }

    public LineNumberInfo getLineNumberInfo(int pc) {
        for (int index = this.u2lineNumberTableLength - 1; index >= 0; --index) {
            LineNumberInfo info = this.lineNumberTable[index];
            if (pc < info.u2startPC) continue;
            return info;
        }
        return this.u2lineNumberTableLength > 0 ? this.lineNumberTable[0] : null;
    }

    public int getLowestLineNumber() {
        int lowestLineNumber = Integer.MAX_VALUE;
        for (int index = 0; index < this.u2lineNumberTableLength; ++index) {
            int lineNumber;
            LineNumberInfo info = this.lineNumberTable[index];
            if (info.getSource() != null || (lineNumber = info.u2lineNumber) >= lowestLineNumber) continue;
            lowestLineNumber = lineNumber;
        }
        return lowestLineNumber == Integer.MAX_VALUE ? 0 : lowestLineNumber;
    }

    public int getHighestLineNumber() {
        int highestLineNumber = 0;
        for (int index = 0; index < this.u2lineNumberTableLength; ++index) {
            int lineNumber;
            LineNumberInfo info = this.lineNumberTable[index];
            if (info.getSource() != null || (lineNumber = info.u2lineNumber) <= highestLineNumber) continue;
            highestLineNumber = lineNumber;
        }
        return highestLineNumber;
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitLineNumberTableAttribute(clazz, method, codeAttribute, this);
    }

    public void lineNumbersAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfoVisitor lineNumberInfoVisitor) {
        for (int index = 0; index < this.u2lineNumberTableLength; ++index) {
            lineNumberInfoVisitor.visitLineNumberInfo(clazz, method, codeAttribute, this.lineNumberTable[index]);
        }
    }
}

