/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.noReturnMethod.MissingReturnInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrFlowInterruptingStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ArgumentListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.Generator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ModifierListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StatementWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.SwitchStatementGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public class CodeBlockGenerator
extends Generator {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.convertToJava.CodeBlockGenerator");
    private static final boolean IN_TEST = ApplicationManager.getApplication().isUnitTestMode();
    private final StringBuilder builder;
    private final ExpressionContext context;
    private final Set<GrStatement> myExitPoints;

    public CodeBlockGenerator(StringBuilder builder, ExpressionContext context) {
        this(builder, context, null);
    }

    public CodeBlockGenerator(StringBuilder builder, ExpressionContext context, @Nullable Collection<GrStatement> exitPoints) {
        this.builder = builder;
        this.context = context;
        this.myExitPoints = new HashSet();
        if (exitPoints != null) {
            this.myExitPoints.addAll(exitPoints);
        }
    }

    @Override
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public ExpressionContext getContext() {
        return this.context;
    }

    public void generateMethodBody(GrMethod method) {
        boolean shouldInsertReturnNull;
        GrOpenBlock block = method.getBlock();
        this.myExitPoints.clear();
        PsiType returnType = this.context.typeProvider.getReturnType(method);
        if (!method.isConstructor() && !PsiType.VOID.equals((Object)returnType)) {
            this.myExitPoints.addAll(ControlFlowUtils.collectReturns(block));
            shouldInsertReturnNull = block != null && !(returnType instanceof PsiPrimitiveType) && MissingReturnInspection.methodMissesSomeReturns(block, MissingReturnInspection.ReturnStatus.getReturnStatus(method));
        } else {
            shouldInsertReturnNull = false;
        }
        if (block != null) {
            this.generateCodeBlock(block, shouldInsertReturnNull);
        }
    }

    @Override
    public void visitMethod(GrMethod method) {
        LOG.error("don't invoke it!!!");
    }

    @Override
    public void visitOpenBlock(GrOpenBlock block) {
        this.generateCodeBlock(block, false);
    }

    public void generateCodeBlock(GrCodeBlock block, boolean shouldInsertReturnNull) {
        GrParameter[] parameters;
        this.builder.append("{");
        if (block.getParent() instanceof GrMethod) {
            GrMethod method = (GrMethod)block.getParent();
            parameters = method.getParameters();
        } else {
            parameters = block instanceof GrClosableBlock ? ((GrClosableBlock)block).getAllParameters() : GrParameter.EMPTY_ARRAY;
        }
        for (GrParameter parameter : parameters) {
            if (!this.context.analyzedVars.toWrap(parameter)) continue;
            StringBuilder typeText = new StringBuilder().append("groovy.lang.Reference");
            GenerationUtil.writeTypeParameters(typeText, new PsiType[]{this.context.typeProvider.getParameterType(parameter)}, parameter, new GeneratorClassNameProvider());
            this.builder.append("final ").append((CharSequence)typeText).append(' ').append(this.context.analyzedVars.toVarName(parameter)).append(" = new ").append((CharSequence)typeText).append('(').append(parameter.getName()).append(");\n");
        }
        this.visitStatementOwner(block, shouldInsertReturnNull);
        this.builder.append("}\n");
    }

    public void visitStatementOwner(GrStatementOwner owner, boolean shouldInsertReturnNull) {
        boolean hasLineFeed = false;
        for (PsiElement e = owner.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (e instanceof GrStatement) {
                ((GrStatement)e).accept(this);
                hasLineFeed = false;
                continue;
            }
            if (TokenSets.COMMENT_SET.contains(e.getNode().getElementType())) {
                this.builder.append(e.getText());
                continue;
            }
            if (!PsiUtil.isLineFeed(e)) continue;
            hasLineFeed = true;
            if (IN_TEST) {
                this.builder.append(CodeBlockGenerator.genSameLineFeed(e.getText()));
                continue;
            }
            this.builder.append(e.getText());
        }
        if (shouldInsertReturnNull) {
            if (!hasLineFeed) {
                this.builder.append('\n');
            }
            this.builder.append("return null;\n");
        }
    }

    private static String genSameLineFeed(String text) {
        int count = StringUtil.countChars((CharSequence)text, (char)'\n');
        return StringUtil.repeatSymbol((char)'\n', (int)count);
    }

    private void writeStatement(@Nullable GrStatement statement, @NotNull StatementWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/plugins/groovy/refactoring/convertToJava/CodeBlockGenerator", "writeStatement"));
        }
        GenerationUtil.writeStatement(this.builder, this.context, statement, writer);
    }

    private static void writeExpression(@NotNull GrExpression expression, @NotNull StringBuilder builder, @NotNull ExpressionContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/convertToJava/CodeBlockGenerator", "writeExpression"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/refactoring/convertToJava/CodeBlockGenerator", "writeExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/convertToJava/CodeBlockGenerator", "writeExpression"));
        }
        expression.accept(new ExpressionGenerator(builder, context));
    }

    @Override
    public void visitConstructorInvocation(final GrConstructorInvocation invocation) {
        this.writeStatement(invocation, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                GrReferenceExpression thisOrSuperKeyword = invocation.getInvokedExpression();
                GrArgumentList argumentList = invocation.getArgumentList();
                GroovyResolveResult resolveResult = invocation.advancedResolve();
                if (thisOrSuperKeyword.getQualifier() == null) {
                    builder.append(thisOrSuperKeyword.getReferenceName());
                } else {
                    CodeBlockGenerator.writeExpression(thisOrSuperKeyword, builder, context);
                }
                new ArgumentListGenerator(builder, context).generate(GrClosureSignatureUtil.createSignature(resolveResult), argumentList.getExpressionArguments(), argumentList.getNamedArguments(), invocation.getClosureArguments(), invocation);
                builder.append(';');
            }
        });
    }

    @Override
    public void visitStatement(GrStatement statement) {
        LOG.error("all statements must be overloaded");
    }

    @Override
    public void visitFlowInterruptStatement(GrFlowInterruptingStatement statement) {
        this.builder.append(statement.getStatementText());
        String name = statement.getLabelName();
        if (name != null) {
            this.builder.append(' ').append(name);
        }
        this.builder.append(';');
    }

    @Override
    public void visitReturnStatement(GrReturnStatement returnStatement) {
        final GrExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            this.builder.append("return;\n");
            return;
        }
        this.writeStatement(returnStatement, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                CodeBlockGenerator.writeReturn(builder, context, returnValue);
            }
        });
    }

    @Override
    public void visitAssertStatement(GrAssertStatement assertStatement) {
        final GrExpression assertion = assertStatement.getAssertion();
        final GrExpression message = assertStatement.getErrorMessage();
        if (assertion != null) {
            this.writeStatement(assertStatement, new StatementWriter(){

                @Override
                public void writeStatement(StringBuilder builder, ExpressionContext context) {
                    builder.append("assert ");
                    CodeBlockGenerator.writeExpression(assertion, builder, context);
                    if (message != null) {
                        builder.append(" : ");
                        CodeBlockGenerator.writeExpression(message, builder, context);
                    }
                    builder.append(';');
                }
            });
        } else if (message != null) {
            this.writeStatement(assertStatement, new StatementWriter(){

                @Override
                public void writeStatement(StringBuilder builder, ExpressionContext context) {
                    builder.append("assert : ");
                    CodeBlockGenerator.writeExpression(message, builder, context);
                    builder.append(';');
                }
            });
        } else {
            this.builder.append("assert;");
        }
    }

    @Override
    public void visitThrowStatement(GrThrowStatement throwStatement) {
        final GrExpression exception = throwStatement.getException();
        if (exception == null) {
            this.builder.append("throw ;");
            return;
        }
        this.writeStatement(throwStatement, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                builder.append("throw ");
                CodeBlockGenerator.writeExpression(exception, builder, context);
                builder.append(';');
            }
        });
    }

    @Override
    public void visitLabeledStatement(final GrLabeledStatement labeledStatement) {
        this.writeStatement(labeledStatement, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                String label = labeledStatement.getName();
                GrStatement statement = labeledStatement.getStatement();
                builder.append(label).append(": ");
                if (statement != null) {
                    statement.accept(new CodeBlockGenerator(builder, context, CodeBlockGenerator.this.myExitPoints));
                }
            }
        });
    }

    @Override
    public void visitExpression(final GrExpression expression) {
        this.writeStatement(expression, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                if (CodeBlockGenerator.this.myExitPoints.contains(expression) && this.isRealExpression(expression)) {
                    CodeBlockGenerator.writeReturn(builder, context, expression);
                } else {
                    CodeBlockGenerator.writeExpression(expression, builder, context);
                    builder.append(';');
                }
            }

            private boolean isRealExpression(GrExpression expression2) {
                PsiType type = expression2.getType();
                if (PsiType.VOID.equals((Object)type)) {
                    return false;
                }
                if (type == PsiType.NULL) {
                    return !PsiUtil.isVoidMethodCall(expression2);
                }
                return true;
            }
        });
    }

    private static void writeReturn(StringBuilder builder, ExpressionContext context, final GrExpression expression) {
        builder.append("return ");
        PsiType expectedReturnType = PsiImplUtil.inferReturnType(expression);
        PsiClassType nnReturnType = expectedReturnType == null || PsiType.VOID.equals((Object)expectedReturnType) ? TypesUtil.getJavaLangObject(expression) : expectedReturnType;
        GenerationUtil.wrapInCastIfNeeded(builder, (PsiType)nnReturnType, expression.getNominalType(), expression, context, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                CodeBlockGenerator.writeExpression(expression, builder, context);
            }
        });
        builder.append(';');
    }

    @Override
    public void visitApplicationStatement(GrApplicationStatement applicationStatement) {
        this.visitExpression(applicationStatement);
    }

    @Override
    public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
    }

    @Override
    public void visitIfStatement(final GrIfStatement ifStatement) {
        this.writeStatement(ifStatement, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                GrExpression condition = ifStatement.getCondition();
                GrStatement thenBranch = ifStatement.getThenBranch();
                GrStatement elseBranch = ifStatement.getElseBranch();
                builder.append("if (");
                if (condition != null) {
                    PsiType type = condition.getType();
                    if (PsiType.BOOLEAN.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(type))) {
                        CodeBlockGenerator.writeExpression(condition, builder, context);
                    } else {
                        GenerationUtil.invokeMethodByName(condition, "asBoolean", GrExpression.EMPTY_ARRAY, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, new ExpressionGenerator(builder, context), ifStatement);
                    }
                }
                builder.append(')');
                if (thenBranch != null) {
                    thenBranch.accept(new CodeBlockGenerator(builder, context.extend(), CodeBlockGenerator.this.myExitPoints));
                }
                if (ifStatement.getElseKeyword() != null) {
                    builder.append(" else ");
                }
                if (elseBranch != null) {
                    elseBranch.accept(new CodeBlockGenerator(builder, context.extend(), CodeBlockGenerator.this.myExitPoints));
                }
            }
        });
    }

    @Override
    public void visitForStatement(GrForStatement forStatement) {
        this.builder.append("for(");
        GrForClause clause = forStatement.getClause();
        ExpressionContext forContext = this.context.extend();
        if (clause instanceof GrForInClause) {
            GrExpression expression = ((GrForInClause)clause).getIteratedExpression();
            GrVariable declaredVariable = clause.getDeclaredVariable();
            LOG.assertTrue(declaredVariable != null);
            CodeBlockGenerator.writeVariableWithoutSemicolonAndInitializer(this.builder, declaredVariable, this.context);
            this.builder.append(" : ");
            if (expression != null) {
                ExpressionContext context = forContext.copy();
                CodeBlockGenerator.writeExpression(expression, this.builder, context);
            }
        } else if (clause instanceof GrTraditionalForClause) {
            GrTraditionalForClause cl = (GrTraditionalForClause)clause;
            GrCondition initialization = cl.getInitialization();
            GrExpression condition = cl.getCondition();
            GrExpression update = cl.getUpdate();
            if (initialization instanceof GrParameter) {
                StringBuilder partBuilder = new StringBuilder();
                CodeBlockGenerator.writeVariableWithoutSemicolonAndInitializer(partBuilder, (GrParameter)initialization, this.context);
                GrExpression initializer = ((GrParameter)initialization).getInitializerGroovy();
                if (initializer != null) {
                    ExpressionContext partContext = forContext.copy();
                    partBuilder.append(" = ");
                    CodeBlockGenerator.writeExpression(initializer, partBuilder, partContext);
                    for (String statement : partContext.myStatements) {
                        this.builder.append(statement).append(", ");
                    }
                    this.builder.append((CharSequence)partBuilder);
                }
            } else if (initialization != null) {
                StringBuilder partBuilder = new StringBuilder();
                ExpressionContext partContext = forContext.copy();
                CodeBlockGenerator.genForPart(this.builder, initialization, new CodeBlockGenerator(partBuilder, partContext, null));
            }
            this.builder.append(';');
            if (condition != null) {
                CodeBlockGenerator.genForPart(this.builder, condition, forContext.copy());
            }
            this.builder.append(';');
            if (update != null) {
                CodeBlockGenerator.genForPart(this.builder, update, forContext.copy());
            }
        }
        this.builder.append(')');
        GrStatement body = forStatement.getBody();
        if (body != null) {
            body.accept(new CodeBlockGenerator(this.builder, forContext, null));
        }
    }

    private static void genForPart(StringBuilder builder, GrExpression part, ExpressionContext context) {
        CodeBlockGenerator.genForPart(builder, (GroovyPsiElement)part, new ExpressionGenerator(new StringBuilder(), context));
    }

    private static void genForPart(StringBuilder builder, GroovyPsiElement part, Generator visitor) {
        part.accept(visitor);
        for (String statement : visitor.getContext().myStatements) {
            builder.append(statement).append(", ");
        }
        builder.append((CharSequence)visitor.getBuilder());
    }

    private static void writeVariableWithoutSemicolonAndInitializer(StringBuilder builder, GrVariable var, ExpressionContext context) {
        ModifierListGenerator.writeModifiers(builder, var.getModifierList());
        TypeWriter.writeType(builder, context.typeProvider.getVarType(var), var);
        builder.append(' ').append(var.getName());
    }

    @Override
    public void visitWhileStatement(final GrWhileStatement whileStatement) {
        this.writeStatement(whileStatement, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                GrExpression condition = whileStatement.getCondition();
                GrStatement body = whileStatement.getBody();
                builder.append("while (");
                if (condition != null) {
                    CodeBlockGenerator.writeExpression(condition, builder, context);
                }
                builder.append(" )");
                if (body != null) {
                    body.accept(new CodeBlockGenerator(builder, context.extend(), null));
                }
            }
        });
    }

    @Override
    public void visitSwitchStatement(final GrSwitchStatement switchStatement) {
        this.writeStatement(switchStatement, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                SwitchStatementGenerator.generate(builder, context, switchStatement);
            }
        });
    }

    @Override
    public void visitTryStatement(GrTryCatchStatement tryCatchStatement) {
        GrOpenBlock tryBlock = tryCatchStatement.getTryBlock();
        GrCatchClause[] catchClauses = tryCatchStatement.getCatchClauses();
        GrFinallyClause finallyClause = tryCatchStatement.getFinallyClause();
        this.builder.append("try");
        tryBlock.accept(this);
        for (GrCatchClause catchClause : catchClauses) {
            catchClause.accept(this);
        }
        if (finallyClause != null) {
            finallyClause.accept(this);
        }
    }

    @Override
    public void visitCatchClause(GrCatchClause catchClause) {
        GrParameter parameter = catchClause.getParameter();
        this.builder.append("catch (");
        CodeBlockGenerator.writeVariableWithoutSemicolonAndInitializer(this.builder, parameter, this.context);
        this.builder.append(") ");
        GrOpenBlock body = catchClause.getBody();
        if (body != null) {
            body.accept(this);
        }
    }

    @Override
    public void visitFinallyClause(GrFinallyClause finallyClause) {
        this.builder.append("finally ");
        GrOpenBlock body = finallyClause.getBody();
        if (body != null) {
            body.accept(this);
        }
    }

    @Override
    public void visitBlockStatement(GrBlockStatement blockStatement) {
        blockStatement.getBlock().accept(this);
    }

    @Override
    public void visitSynchronizedStatement(final GrSynchronizedStatement statement) {
        this.writeStatement(statement, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                GrExpression monitor = statement.getMonitor();
                GrOpenBlock body = statement.getBody();
                builder.append("synchronized(");
                if (monitor != null) {
                    CodeBlockGenerator.writeExpression(monitor, builder, context);
                }
                builder.append(')');
                if (body != null) {
                    body.accept(new CodeBlockGenerator(builder, context.extend(), CodeBlockGenerator.this.myExitPoints));
                }
            }
        });
    }

    @Override
    public void visitVariableDeclaration(final GrVariableDeclaration variableDeclaration) {
        this.writeStatement(variableDeclaration, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                if (variableDeclaration.isTuple()) {
                    CodeBlockGenerator.this.writeTupleDeclaration(variableDeclaration, builder, context);
                } else {
                    GenerationUtil.writeSimpleVarDeclaration(variableDeclaration, builder, context);
                }
            }
        });
    }

    private void writeTupleDeclaration(GrVariableDeclaration variableDeclaration, StringBuilder builder, ExpressionContext expressionContext) {
        GrVariable[] variables = variableDeclaration.getVariables();
        GrExpression tupleInitializer = variableDeclaration.getTupleInitializer();
        if (tupleInitializer instanceof GrListOrMap) {
            for (GrVariable variable : variables) {
                GenerationUtil.writeVariableSeparately(variable, builder, expressionContext);
                builder.append(";\n");
            }
        } else if (tupleInitializer != null) {
            GroovyResolveResult iteratorMethodResult = GenerationUtil.resolveMethod(tupleInitializer, "iterator", GrExpression.EMPTY_ARRAY, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, variableDeclaration);
            PsiType iteratorType = this.inferIteratorType(iteratorMethodResult, tupleInitializer);
            final String iteratorName = CodeBlockGenerator.genIteratorVar(variableDeclaration, builder, expressionContext, tupleInitializer, iteratorType, iteratorMethodResult);
            GrModifierList modifierList = variableDeclaration.getModifierList();
            PsiType iterableTypeParameter = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)iteratorType, (boolean)false);
            for (GrVariable v : variables) {
                ModifierListGenerator.writeModifiers(builder, modifierList);
                PsiType type = this.context.typeProvider.getVarType(v);
                TypeWriter.writeType(builder, type, variableDeclaration);
                builder.append(' ').append(v.getName());
                builder.append(" = ");
                GenerationUtil.wrapInCastIfNeeded(builder, type, iterableTypeParameter, tupleInitializer, expressionContext, new StatementWriter(){

                    @Override
                    public void writeStatement(StringBuilder builder, ExpressionContext context) {
                        builder.append(iteratorName).append(".hasNext() ? ").append(iteratorName).append(".next() : null");
                    }
                });
                builder.append(";\n");
            }
        } else {
            GenerationUtil.writeSimpleVarDeclaration(variableDeclaration, builder, expressionContext);
        }
    }

    private static String genIteratorVar(GrVariableDeclaration variableDeclaration, StringBuilder builder, ExpressionContext expressionContext, @NotNull GrExpression tupleInitializer, PsiType iteratorType, GroovyResolveResult iteratorMethodResult) {
        if (tupleInitializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tupleInitializer", "org/jetbrains/plugins/groovy/refactoring/convertToJava/CodeBlockGenerator", "genIteratorVar"));
        }
        String iteratorName = GenerationUtil.suggestVarName(iteratorType, variableDeclaration, expressionContext);
        builder.append("final ");
        TypeWriter.writeType(builder, iteratorType, variableDeclaration);
        builder.append(' ').append(iteratorName).append(" = ");
        GenerationUtil.invokeMethodByResolveResult(tupleInitializer, iteratorMethodResult, "iterator", GrExpression.EMPTY_ARRAY, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, new ExpressionGenerator(builder, expressionContext), variableDeclaration);
        builder.append(";\n");
        return iteratorName;
    }

    private PsiType inferIteratorType(GroovyResolveResult iteratorMethodResult, GrExpression tupleInitializer) {
        PsiElement method = iteratorMethodResult.getElement();
        if (method instanceof PsiMethod) {
            return iteratorMethodResult.getSubstitutor().substitute(((PsiMethod)method).getReturnType());
        }
        PsiType initializerType = tupleInitializer.getType();
        PsiType iterableParam = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)initializerType, (boolean)false);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.context.project);
        PsiClass iterableClass = facade.findClass("java.util.Iterator", tupleInitializer.getResolveScope());
        if (iterableClass != null && iterableParam != null) {
            return facade.getElementFactory().createType(iterableClass, iterableParam);
        }
        return facade.getElementFactory().createTypeFromText("java.util.Iterator", (PsiElement)tupleInitializer);
    }

    @Override
    public void visitVariable(GrVariable variable) {
        super.visitVariable(variable);
    }
}

