/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeId {
    private final String myFileUrl;
    private final PsiElement myElement;
    private final String myLocationRootMark;
    private int hash;
    @NonNls
    public static final String CONTROLLERS_SUBTREE = "CONTROLLERS_SUBTREE";
    @NonNls
    public static final String CONTROLLER_IN_CONTROLLERS_SUBTREE = "CONTROLLER_IN_CONTROLLERS_SUBTREE";
    @NonNls
    public static final String ACTION_IN_CONTROLLERS_SUBTREE = "ACTION_IN_CONTROLLERS_SUBTREE";
    @NonNls
    public static final String DOMAINS_SUBTREE = "DOMAINS_SUBTREE";
    @NonNls
    public static final String DOMAIN_CLASS_IN_DOMAINS_SUBTREE = "DOMAIN_CLASS_IN_DOMAINS_SUBTREE";
    @NonNls
    public static final String VIEWS_SUBTREE = "VIEWS_SUBTREE";
    @NonNls
    public static final String TESTS_TREE = "TESTS";
    @NonNls
    public static final String TEST_CLASS_IN_TESTS_SUBTREE = "TEST_INTESTS";

    public NodeId(@NotNull String fileUrl, @Nullable String locationRootMark) {
        if (fileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileUrl", "org/jetbrains/plugins/groovy/mvc/projectView/NodeId", "<init>"));
        }
        this(fileUrl, null, locationRootMark);
    }

    public NodeId(@NotNull PsiElement element, @Nullable String locationRootMark) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/mvc/projectView/NodeId", "<init>"));
        }
        this(null, element, locationRootMark);
    }

    private NodeId(@Nullable String fileUrl, @Nullable PsiElement element, @Nullable String locationRootMark) {
        this.myFileUrl = fileUrl;
        this.myElement = element;
        this.myLocationRootMark = locationRootMark;
    }

    @Nullable
    public String getFileUrl() {
        return this.myFileUrl;
    }

    @Nullable
    public String getLocationRootMark() {
        return this.myLocationRootMark;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myElement;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("[url = ");
        buff.append(this.getFileUrl());
        buff.append(", psiElement = ");
        buff.append(this.getPsiElement());
        buff.append(", location mark = (");
        buff.append(this.getLocationRootMark());
        buff.append(")]");
        return buff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeId nodeId = (NodeId)o;
        if (this.myFileUrl != null ? !this.myFileUrl.equals(nodeId.myFileUrl) : nodeId.myFileUrl != null) {
            return false;
        }
        if (this.myLocationRootMark != null ? !this.myLocationRootMark.equals(nodeId.myLocationRootMark) : nodeId.myLocationRootMark != null) {
            return false;
        }
        return this.myElement == nodeId.myElement;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.myFileUrl != null ? this.myFileUrl.hashCode() : 1;
            this.hash = 31 * this.hash + (this.myLocationRootMark != null ? this.myLocationRootMark.hashCode() : 0);
            this.hash = this.myElement != null ? 31 * this.hash + this.myElement.hashCode() : 31 * this.hash;
        }
        return this.hash;
    }
}

