/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;

public class GrFieldStub
extends StubBase<GrField>
implements NamedStub<GrField> {
    public static final byte IS_PROPERTY = 1;
    public static final byte IS_ENUM_CONSTANT = 2;
    public static final byte IS_DEPRECATED_BY_DOC_TAG = 4;
    private final byte myFlags;
    private final StringRef myName;
    private final String[] myAnnotations;
    private final String[] myNamedParameters;
    private final String myTypeText;

    public GrFieldStub(StubElement parent, StringRef name, String[] annotations, String[] namedParameters, @NotNull IStubElementType elemType, byte flags, @Nullable String typeText) {
        if (elemType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elemType", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFieldStub", "<init>"));
        }
        super(parent, elemType);
        this.myName = name;
        this.myAnnotations = annotations;
        this.myNamedParameters = namedParameters;
        this.myFlags = flags;
        this.myTypeText = typeText;
    }

    @NotNull
    public String getName() {
        String string = StringRef.toString((StringRef)this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFieldStub", "getName"));
        }
        return string;
    }

    public String[] getAnnotations() {
        return this.myAnnotations;
    }

    @NotNull
    public String[] getNamedParameters() {
        if (this.myNamedParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFieldStub", "getNamedParameters"));
        }
        return this.myNamedParameters;
    }

    public boolean isProperty() {
        return (this.myFlags & 1) != 0;
    }

    public boolean isDeprecatedByDocTag() {
        return (this.myFlags & 4) != 0;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Nullable
    public String getTypeText() {
        return this.myTypeText;
    }

    public static byte buildFlags(GrField field) {
        byte f = 0;
        if (field instanceof GrEnumConstant) {
            f = (byte)(f | 2);
        }
        if (field.isProperty()) {
            f = (byte)(f | 1);
        }
        if (PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)field)) {
            f = (byte)(f | 4);
        }
        return f;
    }

    public static boolean isEnumConstant(byte flags) {
        return (flags & 2) != 0;
    }
}

