/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyElementPattern;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyNamedArgumentPattern
extends GroovyElementPattern<GrNamedArgument, GroovyNamedArgumentPattern> {
    public GroovyNamedArgumentPattern() {
        super(GrNamedArgument.class);
    }

    public GroovyNamedArgumentPattern withLabel(final @NotNull String label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyNamedArgumentPattern", "withLabel"));
        }
        return (GroovyNamedArgumentPattern)this.with((PatternCondition)new PatternCondition<GrNamedArgument>("left"){

            public boolean accepts(@NotNull GrNamedArgument namedArgument, ProcessingContext context) {
                if (namedArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyNamedArgumentPattern$1", "accepts"));
                }
                return label.equals(namedArgument.getLabelName());
            }
        });
    }

    public GroovyNamedArgumentPattern withLabel(final @NotNull StringPattern labelPattern) {
        if (labelPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelPattern", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyNamedArgumentPattern", "withLabel"));
        }
        return (GroovyNamedArgumentPattern)this.with((PatternCondition)new PatternCondition<GrNamedArgument>("left"){

            public boolean accepts(@NotNull GrNamedArgument namedArgument, ProcessingContext context) {
                if (namedArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyNamedArgumentPattern$2", "accepts"));
                }
                return labelPattern.accepts((Object)namedArgument.getLabelName(), context);
            }
        });
    }

    public GroovyNamedArgumentPattern withExpression(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyNamedArgumentPattern", "withExpression"));
        }
        return (GroovyNamedArgumentPattern)this.with((PatternCondition)new PatternCondition<GrNamedArgument>("left"){

            public boolean accepts(@NotNull GrNamedArgument namedArgument, ProcessingContext context) {
                if (namedArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyNamedArgumentPattern$3", "accepts"));
                }
                return pattern.accepts((Object)namedArgument.getExpression(), context);
            }
        });
    }

    public GroovyNamedArgumentPattern isParameterOfMethodCall(final @Nullable ElementPattern<? extends GrCall> methodCall) {
        return (GroovyNamedArgumentPattern)this.with((PatternCondition)new PatternCondition<GrNamedArgument>("left"){

            public boolean accepts(@NotNull GrNamedArgument namedArgument, ProcessingContext context) {
                if (namedArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyNamedArgumentPattern$4", "accepts"));
                }
                GrCall call = PsiUtil.getCallByNamedParameter(namedArgument);
                return call != null && (methodCall == null || methodCall.accepts((Object)call, context));
            }
        });
    }
}

