/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrWhileStatementImpl
extends GroovyPsiElementImpl
implements GrWhileStatement {
    public GrWhileStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrWhileStatementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitWhileStatement(this);
    }

    public String toString() {
        return "WHILE statement";
    }

    @Override
    @Nullable
    public GrExpression getCondition() {
        PsiElement lParenth = this.getLParenth();
        if (lParenth == null) {
            return null;
        }
        PsiElement afterLParenth = PsiUtil.skipWhitespacesAndComments(lParenth.getNextSibling(), true);
        if (afterLParenth instanceof GrExpression) {
            return (GrExpression)afterLParenth;
        }
        return null;
    }

    @Override
    @Nullable
    public GrStatement getBody() {
        ArrayList<GrStatement> statements = new ArrayList<GrStatement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrStatement)) continue;
            statements.add((GrStatement)cur);
        }
        if (this.getCondition() == null && !statements.isEmpty()) {
            return (GrStatement)statements.get(0);
        }
        if (statements.size() > 1) {
            return (GrStatement)statements.get(1);
        }
        return null;
    }

    @Override
    public <T extends GrCondition> T replaceBody(T newBody) throws IncorrectOperationException {
        return PsiImplUtil.replaceBody(newBody, this.getBody(), this.getNode(), this.getProject());
    }

    @Override
    public PsiElement getRParenth() {
        return this.findChildByType(GroovyTokenTypes.mRPAREN);
    }

    @Override
    public PsiElement getLParenth() {
        return this.findChildByType(GroovyTokenTypes.mLPAREN);
    }
}

