/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.LazyFqnClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class GrLiteralClassType
extends PsiClassType {
    protected final GlobalSearchScope myScope;
    protected final JavaPsiFacade myFacade;
    private final GroovyPsiManager myGroovyPsiManager;

    public GrLiteralClassType(LanguageLevel languageLevel, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "<init>"));
        }
        super(languageLevel);
        this.myScope = scope;
        this.myFacade = facade;
        this.myGroovyPsiManager = GroovyPsiManager.getInstance(this.myFacade.getProject());
    }

    @NotNull
    protected abstract String getJavaClassName();

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiClassType.ClassResolveResult classResolveResult = new PsiClassType.ClassResolveResult(){
            private final PsiClass myBaseClass;
            private final NotNullLazyValue<PsiSubstitutor> mySubstitutor;
            {
                this.myBaseClass = GrLiteralClassType.this.resolve();
                this.mySubstitutor = new NotNullLazyValue<PsiSubstitutor>(){

                    @NotNull
                    protected PsiSubstitutor compute() {
                        PsiSubstitutor psiSubstitutor = GrLiteralClassType.this.inferSubstitutor(myBaseClass);
                        if (psiSubstitutor == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType$1$1", "compute"));
                        }
                        return psiSubstitutor;
                    }
                };
            }

            public PsiClass getElement() {
                return this.myBaseClass;
            }

            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = (PsiSubstitutor)this.mySubstitutor.getValue();
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType$1", "getSubstitutor"));
                }
                return psiSubstitutor;
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                return true;
            }

            public boolean isStaticsScopeCorrect() {
                return true;
            }

            @Nullable
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }
        };
        if (classResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "resolveGenerics"));
        }
        return classResolveResult;
    }

    @NotNull
    private PsiSubstitutor inferSubstitutor(@Nullable PsiClass myBaseClass) {
        if (myBaseClass != null) {
            PsiType[] typeArgs = this.getParameters();
            PsiTypeParameter[] typeParams = myBaseClass.getTypeParameters();
            if (typeParams.length == typeArgs.length) {
                PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY.putAll(myBaseClass, typeArgs);
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "inferSubstitutor"));
                }
                return psiSubstitutor;
            }
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY.putAll(myBaseClass, GrLiteralClassType.createArray((int)typeParams.length));
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "inferSubstitutor"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "inferSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public abstract String getClassName();

    @NotNull
    public String getPresentableText() {
        String name = this.getClassName();
        Object[] params = this.getParameters();
        if (params.length == 0 || params[0] == null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "getPresentableText"));
            }
            return string;
        }
        String string = name + "<" + StringUtil.join((Object[])params, (Function)new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return psiType.getPresentableText();
            }
        }, (String)", ") + ">";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String name = this.getJavaClassName();
        Object[] params = this.getParameters();
        if (params.length == 0 || params[0] == null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "getCanonicalText"));
            }
            return string;
        }
        Function<PsiType, String> f = new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return psiType.getCanonicalText();
            }
        };
        String string = name + "<" + StringUtil.join((Object[])params, (Function)f, (String)", ") + ">";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public GlobalSearchScope getScope() {
        GlobalSearchScope globalSearchScope = this.myScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "getScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public PsiClass resolve() {
        return this.myGroovyPsiManager.findClassWithCache(this.getJavaClassName(), this.getResolveScope());
    }

    @NotNull
    public PsiClassType rawType() {
        PsiClassType psiClassType = this.myGroovyPsiManager.createTypeByFQClassName(this.getJavaClassName(), this.myScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "rawType"));
        }
        return psiClassType;
    }

    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "equalsToText"));
        }
        return text.equals(this.getJavaClassName());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    protected static String getInternalCanonicalText(@Nullable PsiType type) {
        return type == null ? "java.lang.Object" : type.getInternalCanonicalText();
    }

    @NotNull
    protected PsiType getLeastUpperBound(PsiType ... psiTypes) {
        PsiType result = null;
        PsiManager manager = this.getPsiManager();
        for (PsiType other : psiTypes) {
            result = TypesUtil.getLeastUpperBoundNullable(result, other, manager);
        }
        Object object = result == null ? LazyFqnClassType.getLazyType("java.lang.Object", this.getLanguageLevel(), this.getResolveScope(), this.myFacade) : result;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrLiteralClassType", "getLeastUpperBound"));
        }
        return object;
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myFacade.getProject());
    }
}

