/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockGenerator;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockWithRange;

public class GrLabelBlock
extends GroovyBlockWithRange {
    private final List<Block> myBlocks;

    public GrLabelBlock(@NotNull ASTNode node, List<ASTNode> subStatements, boolean classLevel, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull FormattingContext context) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/formatter/blocks/GrLabelBlock", "<init>"));
        }
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "org/jetbrains/plugins/groovy/formatter/blocks/GrLabelBlock", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/formatter/blocks/GrLabelBlock", "<init>"));
        }
        super(node, indent, GrLabelBlock.createTextRange(subStatements), wrap, context);
        GroovyBlockGenerator generator = new GroovyBlockGenerator(this);
        this.myBlocks = generator.generateSubBlockForCodeBlocks(classLevel, subStatements, false);
    }

    private static TextRange createTextRange(List<ASTNode> subStatements) {
        ASTNode first = subStatements.get(0);
        ASTNode last = subStatements.get(subStatements.size() - 1);
        return new TextRange(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.myBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/blocks/GrLabelBlock", "getSubBlocks"));
        }
        return list;
    }
}

