/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(PsiElement element) {
        return element instanceof GrVariable;
    }

    public boolean isDeclarationWriteAccess(PsiElement element) {
        return element instanceof GrVariable && ((GrVariable)element).getInitializerGroovy() != null;
    }

    public ReadWriteAccessDetector.Access getReferenceAccess(PsiElement referencedElement, PsiReference reference) {
        return this.getExpressionAccess(reference.getElement());
    }

    public ReadWriteAccessDetector.Access getExpressionAccess(PsiElement expression) {
        if (expression instanceof GrExpression) {
            PsiElement actualReferee;
            GrExpression expr = (GrExpression)expression;
            boolean readAccess = PsiUtil.isAccessedForReading(expr);
            boolean writeAccess = PsiUtil.isAccessedForWriting(expr);
            if (!writeAccess && expr instanceof GrReferenceExpression && (actualReferee = ((GrReferenceExpression)expr).resolve()) instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)actualReferee)) {
                writeAccess = true;
                readAccess = false;
            }
            if (writeAccess && readAccess) {
                return ReadWriteAccessDetector.Access.ReadWrite;
            }
            return writeAccess ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
        }
        if (expression instanceof PsiExpression) {
            PsiElement actualReferee;
            PsiExpression expr = (PsiExpression)expression;
            boolean readAccess = com.intellij.psi.util.PsiUtil.isAccessedForReading((PsiExpression)expr);
            boolean writeAccess = com.intellij.psi.util.PsiUtil.isAccessedForWriting((PsiExpression)expr);
            if (!writeAccess && expr instanceof PsiReferenceExpression && (actualReferee = ((PsiReferenceExpression)expr).resolve()) instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)actualReferee)) {
                writeAccess = true;
                readAccess = false;
            }
            if (writeAccess && readAccess) {
                return ReadWriteAccessDetector.Access.ReadWrite;
            }
            return writeAccess ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
        }
        return ReadWriteAccessDetector.Access.Read;
    }
}

