/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.exception.CatchParameterUsedVisitor;
import org.jetbrains.plugins.groovy.codeInspection.exception.GrExceptionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyUnusedCatchParameterInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Error handling" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyUnusedCatchParameterInspection", "getGroupDisplayName"));
        }
        return "Error handling";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unused catch parameter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyUnusedCatchParameterInspection", "getDisplayName"));
        }
        return "Unused catch parameter";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyUnusedCatchParameterInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitCatchClause(GrCatchClause catchClause) {
            super.visitCatchClause(catchClause);
            GrOpenBlock block = catchClause.getBody();
            if (block == null) {
                return;
            }
            GrParameter parameter = catchClause.getParameter();
            if (parameter == null) {
                return;
            }
            if (GrExceptionUtil.ignore(parameter)) {
                return;
            }
            CatchParameterUsedVisitor visitor = new CatchParameterUsedVisitor(parameter);
            block.accept(visitor);
            if (!visitor.isUsed()) {
                PsiElement nameIdentifier = parameter.getNameIdentifierGroovy();
                this.registerError(nameIdentifier, "Unused catch parameter '#ref' #loc", new LocalQuickFix[]{QuickFixFactory.getInstance().createRenameElementFix((PsiNamedElement)parameter, "ignored")}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }
    }
}

