/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyDivideByZeroInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDivideByZeroInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Divide by zero" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDivideByZeroInspection", "getDisplayName"));
        }
        return "Divide by zero";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Division by zero #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDivideByZeroInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static boolean isZero(GrExpression expression) {
        String text = expression.getText();
        return "0".equals(text) || "0x0".equals(text) || "0X0".equals(text) || "0.0".equals(text) || "0L".equals(text) || "0l".equals(text);
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyDivideByZeroInspection$Visitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mDIV.equals(tokenType) && !GroovyTokenTypes.mMOD.equals(tokenType)) {
                return;
            }
            if (!GroovyDivideByZeroInspection.isZero(rhs)) {
                return;
            }
            this.registerError(expression);
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            GrExpression rhs = expression.getRValue();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(GroovyTokenTypes.mDIV_ASSIGN) && !tokenType.equals(GroovyTokenTypes.mMOD_ASSIGN)) {
                return;
            }
            if (!GroovyDivideByZeroInspection.isZero(rhs)) {
                return;
            }
            this.registerError(expression);
        }
    }
}

