/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrBinaryExprInfo
implements CallInfo<GrBinaryExpression> {
    private final GrBinaryExpression myExpr;

    public GrBinaryExprInfo(GrBinaryExpression expr) {
        this.myExpr = expr;
    }

    @Override
    @Nullable
    public GrArgumentList getArgumentList() {
        return null;
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        GrExpression operand = this.myExpr.getRightOperand();
        return new PsiType[]{operand != null ? operand.getType() : null};
    }

    @Override
    @Nullable
    public GrExpression getInvokedExpression() {
        return this.myExpr.getLeftOperand();
    }

    @Override
    @Nullable
    public PsiType getQualifierInstanceType() {
        return this.myExpr.getLeftOperand().getType();
    }

    @Override
    @NotNull
    public PsiElement getHighlightElementForCategoryQualifier() {
        PsiElement psiElement = this.myExpr.getOperationToken();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrBinaryExprInfo", "getHighlightElementForCategoryQualifier"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement getElementToHighlight() {
        PsiElement psiElement = this.myExpr.getOperationToken();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrBinaryExprInfo", "getElementToHighlight"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult groovyResolveResult = PsiImplUtil.extractUniqueResult(this.multiResolve());
        if (groovyResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrBinaryExprInfo", "advancedResolve"));
        }
        return groovyResolveResult;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve() {
        GroovyResolveResult[] groovyResolveResultArray = this.myExpr.multiResolve(false);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrBinaryExprInfo", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public GrBinaryExpression getCall() {
        GrBinaryExpression grBinaryExpression = this.myExpr;
        if (grBinaryExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrBinaryExprInfo", "getCall"));
        }
        return grBinaryExpression;
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        GrExpression right = this.myExpr.getRightOperand();
        if (right != null) {
            GrExpression[] grExpressionArray = new GrExpression[]{right};
            if (grExpressionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrBinaryExprInfo", "getExpressionArguments"));
            }
            return grExpressionArray;
        }
        if (GrExpression.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrBinaryExprInfo", "getExpressionArguments"));
        }
        return GrExpression.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public GrClosableBlock[] getClosureArguments() {
        if (GrClosableBlock.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrBinaryExprInfo", "getClosureArguments"));
        }
        return GrClosableBlock.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        if (GrNamedArgument.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrBinaryExprInfo", "getNamedArguments"));
        }
        return GrNamedArgument.EMPTY_ARRAY;
    }
}

