/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import java.lang.annotation.Annotation;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Nullable;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.internal.builder.TypeBuilderFactory;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenComponentModelRuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeModelRuleExtractor<A extends Annotation, T, U extends T>
extends AbstractAnnotationDrivenComponentModelRuleExtractor<A> {
    private final String modelName;
    private final ModelType<T> baseInterface;
    private final ModelType<U> baseImplementation;
    private final ModelType<?> builderInterface;
    private final ModelSchemaStore schemaStore;
    private final TypeBuilderFactory<T> typeBuilderFactory;

    public TypeModelRuleExtractor(String modelName, Class<T> baseInterface, Class<U> baseImplementation, Class<?> builderInterface, ModelSchemaStore schemaStore, TypeBuilderFactory<T> typeBuilderFactory) {
        this.modelName = modelName;
        this.schemaStore = schemaStore;
        this.typeBuilderFactory = typeBuilderFactory;
        this.baseInterface = ModelType.of(baseInterface);
        this.baseImplementation = ModelType.of(baseImplementation);
        this.builderInterface = ModelType.of(builderInterface);
    }

    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition) {
        try {
            ModelType<T> type = this.readType(ruleDefinition);
            ModelSchema schema = this.schemaStore.getSchema(type);
            TypeBuilderInternal<T> builder = this.typeBuilderFactory.create(schema);
            ruleDefinition.getRuleInvoker().invoke(new Object[]{builder});
            return this.createRegistration(ruleDefinition, type, builder);
        }
        catch (InvalidModelException e) {
            throw this.invalidModelRule(ruleDefinition, e);
        }
    }

    @Nullable
    protected abstract <R, S> ExtractedModelRule createRegistration(MethodRuleDefinition<R, S> var1, ModelType<? extends T> var2, TypeBuilderInternal<T> var3);

    protected ModelType<? extends T> readType(MethodRuleDefinition<?, ?> ruleDefinition) {
        this.assertIsVoidMethod(ruleDefinition);
        if (ruleDefinition.getReferences().size() != 1) {
            throw new InvalidModelException(String.format("Method %s must have a single parameter of type '%s'.", this.getDescription(), this.builderInterface.toString()));
        }
        ModelReference subjectReference = ruleDefinition.getSubjectReference();
        ModelType builder = subjectReference.getType();
        if (!this.builderInterface.isAssignableFrom(builder)) {
            throw new InvalidModelException(String.format("Method %s must have a single parameter of type '%s'.", this.getDescription(), this.builderInterface.toString()));
        }
        if (builder.getTypeVariables().size() != 1) {
            throw new InvalidModelException(String.format("Parameter of type '%s' must declare a type parameter.", this.builderInterface.toString()));
        }
        ModelType subType = (ModelType)builder.getTypeVariables().get(0);
        if (subType.isWildcard()) {
            throw new InvalidModelException(String.format("%s type '%s' cannot be a wildcard type (i.e. cannot use ? super, ? extends etc.).", StringUtils.capitalize((String)this.modelName), subType.toString()));
        }
        if (!this.baseInterface.isAssignableFrom(subType)) {
            throw new InvalidModelException(String.format("%s type '%s' is not a subtype of '%s'.", StringUtils.capitalize((String)this.modelName), subType.toString(), this.baseInterface.toString()));
        }
        return subType.asSubtype(this.baseInterface);
    }

    protected InvalidModelRuleDeclarationException invalidModelRule(MethodRuleDefinition<?, ?> ruleDefinition, InvalidModelException e) {
        StringBuilder sb = new StringBuilder();
        ruleDefinition.getDescriptor().describeTo((Appendable)sb);
        sb.append(String.format(" is not a valid %s model rule method.", this.modelName));
        return new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
    }

    protected ModelType<? extends U> determineImplementationType(ModelType<? extends T> type, TypeBuilderInternal<T> builder) {
        for (Class<?> internalView : builder.getInternalViews()) {
            if (internalView.isInterface()) continue;
            throw new InvalidModelException(String.format("Internal view '%s' must be an interface.", internalView.getName()));
        }
        Class<T> implementation = builder.getDefaultImplementation();
        if (implementation == null) {
            return null;
        }
        ModelType implementationType = ModelType.of(implementation);
        if (!this.baseImplementation.isAssignableFrom(implementationType)) {
            throw new InvalidModelException(String.format("%s implementation '%s' must extend '%s'.", StringUtils.capitalize((String)this.modelName), implementationType, this.baseImplementation));
        }
        ModelType asSubclass = implementationType.asSubtype(this.baseImplementation);
        if (!type.isAssignableFrom(asSubclass)) {
            throw new InvalidModelException(String.format("%s implementation '%s' must implement '%s'.", StringUtils.capitalize((String)this.modelName), asSubclass, type));
        }
        for (Class<T> clazz : builder.getInternalViews()) {
            if (clazz.isAssignableFrom(implementation)) continue;
            throw new InvalidModelException(String.format("%s implementation '%s' must implement internal view '%s'.", StringUtils.capitalize((String)this.modelName), asSubclass, clazz.getName()));
        }
        try {
            asSubclass.getRawClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsmException) {
            throw new InvalidModelException(String.format("%s implementation '%s' must have public default constructor.", StringUtils.capitalize((String)this.modelName), asSubclass));
        }
        return asSubclass;
    }
}

