/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.BiAction;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultProjectSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetFactory;
import org.gradle.language.base.internal.model.ComponentSpecInitializer;
import org.gradle.language.base.internal.registry.DefaultLanguageRegistry;
import org.gradle.language.base.internal.registry.LanguageRegistration;
import org.gradle.language.base.internal.registry.LanguageRegistry;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.InputUsingModelAction;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.Service;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.extract.FactoryBasedNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class LanguageBasePlugin
implements Plugin<Project> {
    private final ModelRegistry modelRegistry;

    @Inject
    public LanguageBasePlugin(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project target) {
        target.getPluginManager().apply(LifecycleBasePlugin.class);
        this.applyRules(this.modelRegistry);
    }

    private void applyRules(ModelRegistry modelRegistry) {
        final String baseDescriptor = LanguageBasePlugin.class.getSimpleName() + "#";
        modelRegistry.configure(ModelActionRole.Defaults, DirectNodeNoInputsModelAction.of((ModelReference)ModelReference.of((String)"binaries"), (ModelRuleDescriptor)new SimpleModelRuleDescriptor(baseDescriptor + "attachBuildTasks"), (Action)new Action<MutableModelNode>(){

            public void execute(MutableModelNode binariesNode) {
                binariesNode.applyToAllLinks(ModelActionRole.Finalize, (ModelAction)InputUsingModelAction.single((ModelReference)ModelReference.of(BinarySpec.class), (ModelRuleDescriptor)new SimpleModelRuleDescriptor(baseDescriptor + "attachBuildTask"), (ModelReference)ModelReference.of(ITaskFactory.class), (BiAction)new BiAction<BinarySpec, ITaskFactory>(){

                    public void execute(BinarySpec binary, ITaskFactory taskFactory) {
                        BinarySpecInternal binarySpecInternal = (BinarySpecInternal)binary;
                        if (!binarySpecInternal.isLegacyBinary()) {
                            TaskInternal binaryLifecycleTask = (TaskInternal)taskFactory.create(binarySpecInternal.getProjectScopedName(), DefaultTask.class);
                            binaryLifecycleTask.setGroup("build");
                            binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
                            binary.setBuildTask((Task)binaryLifecycleTask);
                        }
                    }
                }));
            }
        }));
        modelRegistry.getRoot().applyToAllLinksTransitive(ModelActionRole.Defaults, DirectNodeNoInputsModelAction.of((ModelReference)ModelReference.of(BinarySpec.class), (ModelRuleDescriptor)new SimpleModelRuleDescriptor(baseDescriptor + ComponentSpecInitializer.class.getSimpleName() + ".binaryAction()"), ComponentSpecInitializer.binaryAction()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Service
        LanguageSourceSetFactory languageSourceSetFactory(ServiceRegistry serviceRegistry) {
            return new LanguageSourceSetFactory("sourceSets", (FileResolver)serviceRegistry.get(FileResolver.class));
        }

        @Model
        void binaries(BinaryContainer binaries) {
        }

        @BinaryType
        void registerBaseBinarySpec(BinaryTypeBuilder<BinarySpec> builder) {
            builder.defaultImplementation(BaseBinarySpec.class);
            builder.internalView(BinarySpecInternal.class);
        }

        @Mutate
        void registerSourceSetTypes(LanguageSourceSetFactory languageSourceSetFactory, LanguageRegistry languageRegistry) {
            Iterator i$ = languageRegistry.iterator();
            while (i$.hasNext()) {
                LanguageRegistration languageRegistration = (LanguageRegistration)i$.next();
                this.register(languageSourceSetFactory, languageRegistration);
            }
        }

        private <T extends LanguageSourceSet> void register(LanguageSourceSetFactory lssFactory, LanguageRegistration<T> languageRegistration) {
            lssFactory.register(languageRegistration.getSourceSetType(), languageRegistration.getSourceSetImplementationType(), languageRegistration.getRuleDescriptor());
        }

        @Mutate
        void registerSourceSetNodeInitializer(NodeInitializerRegistry nodeInitializerRegistry, LanguageSourceSetFactory languageSourceSetFactory) {
            nodeInitializerRegistry.registerStrategy((NodeInitializerExtractionStrategy)new FactoryBasedNodeInitializerExtractionStrategy((InstanceFactory)languageSourceSetFactory));
        }

        @Model
        ProjectSourceSet sources(ServiceRegistry serviceRegistry) {
            return (ProjectSourceSet)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultProjectSourceSet.class, new Object[0]);
        }

        @Service
        LanguageRegistry languages() {
            return new DefaultLanguageRegistry();
        }

        @Mutate
        void copyBinaryTasksToTaskContainer(TaskContainer tasks, ModelMap<BinarySpec> binaries) {
            for (BinarySpec binary : binaries) {
                tasks.addAll((Collection)((Object)binary.getTasks()));
                Task buildTask = binary.getBuildTask();
                if (buildTask == null) continue;
                tasks.add((Object)buildTask);
            }
        }

        @Mutate
        void attachBinariesToAssembleLifecycle(@Path(value="tasks.assemble") Task assemble, ModelMap<BinarySpecInternal> binaries) {
            ArrayList notBuildable = Lists.newArrayList();
            boolean hasBuildableBinaries = false;
            for (BinarySpecInternal binary : binaries) {
                if (binary.isLegacyBinary()) continue;
                if (binary.isBuildable()) {
                    assemble.dependsOn(new Object[]{binary});
                    hasBuildableBinaries = true;
                    continue;
                }
                notBuildable.add(binary);
            }
            if (!hasBuildableBinaries && !notBuildable.isEmpty()) {
                assemble.doFirst((Action)new CheckForNotBuildableBinariesAction(notBuildable));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CheckForNotBuildableBinariesAction
        implements Action<Task> {
            private final List<BinarySpecInternal> notBuildable;

            public CheckForNotBuildableBinariesAction(List<BinarySpecInternal> notBuildable) {
                this.notBuildable = notBuildable;
            }

            public void execute(Task task) {
                Set taskDependencies = task.getTaskDependencies().getDependencies(task);
                if (taskDependencies.isEmpty()) {
                    TreeFormatter formatter = new TreeFormatter();
                    formatter.node("No buildable binaries found");
                    formatter.startChildren();
                    for (BinarySpecInternal binary : this.notBuildable) {
                        formatter.node(binary.getDisplayName());
                        formatter.startChildren();
                        binary.getBuildAbility().explain((TreeVisitor<? super String>)formatter);
                        formatter.endChildren();
                    }
                    formatter.endChildren();
                    throw new GradleException(formatter.toString());
                }
            }
        }
    }
}

