/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal;

import org.gradle.api.internal.file.FileResolver;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.model.internal.core.BaseInstanceFactory;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.ComponentSpecInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageSourceSetFactory
extends BaseInstanceFactory<LanguageSourceSet> {
    private final FileResolver fileResolver;

    public LanguageSourceSetFactory(String displayName, FileResolver fileResolver) {
        super(displayName, LanguageSourceSet.class, BaseLanguageSourceSet.class);
        this.fileResolver = fileResolver;
    }

    public <T extends LanguageSourceSet, V extends T> void register(ModelType<T> type, final ModelType<V> implementationType, ModelRuleDescriptor ruleDescriptor) {
        InstanceFactory.TypeRegistrationBuilder registration = this.register(type, ruleDescriptor);
        registration.withImplementation(implementationType, new InstanceFactory.ImplementationFactory<T>(){

            public T create(ModelType<? extends T> publicType, String sourceSetName, MutableModelNode modelNode) {
                return BaseLanguageSourceSet.create(publicType.getConcreteClass(), implementationType.getConcreteClass(), sourceSetName, LanguageSourceSetFactory.this.determineParentName(modelNode), LanguageSourceSetFactory.this.fileResolver);
            }
        });
    }

    private String determineParentName(MutableModelNode modelNode) {
        MutableModelNode grandparentNode = modelNode.getParent().getParent();
        if (grandparentNode != null) {
            if (grandparentNode.getPrivateData() instanceof BaseBinarySpec) {
                BaseBinarySpec binarySpecInternal = (BaseBinarySpec)grandparentNode.getPrivateData();
                return binarySpecInternal.getComponent() == null ? binarySpecInternal.getName() : binarySpecInternal.getComponent().getName();
            }
            if (grandparentNode.getPrivateData() instanceof ComponentSpecInternal) {
                return ((ComponentSpecInternal)grandparentNode.getPrivateData()).getName();
            }
        }
        return modelNode.getParent().getPath().getName();
    }
}

