/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.transparencyfilters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.transparencyfilters.TransparencyFilter;

public class TransparencyFilterTrueColor
extends TransparencyFilter {
    private final int transparent_red;
    private final int transparent_green;
    private final int transparent_blue;
    private final int transparent_color;

    public TransparencyFilterTrueColor(byte[] bytes) throws ImageReadException, IOException {
        super(bytes);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        this.transparent_red = this.read2Bytes("transparent_red", is, "tRNS: Missing transparent_color");
        this.transparent_green = this.read2Bytes("transparent_green", is, "tRNS: Missing transparent_color");
        this.transparent_blue = this.read2Bytes("transparent_blue", is, "tRNS: Missing transparent_color");
        this.transparent_color = (0xFF & this.transparent_red) << 16 | (0xFF & this.transparent_green) << 8 | (0xFF & this.transparent_blue) << 0;
    }

    @Override
    public int filter(int rgb, int sample) throws ImageReadException, IOException {
        if ((0xFFFFFF & rgb) == this.transparent_color) {
            return 0;
        }
        return rgb;
    }
}

