/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryBuilder;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RefList;

public class InMemoryRepository
extends DfsRepository {
    private static final AtomicInteger packId = new AtomicInteger();
    private final DfsObjDatabase objdb = new MemObjDatabase(this);
    private final DfsRefDatabase refdb = new MemRefDatabase();

    public InMemoryRepository(DfsRepositoryDescription repoDesc) {
        this((Builder)new Builder().setRepositoryDescription(repoDesc));
    }

    private InMemoryRepository(Builder builder) {
        super(builder);
    }

    @Override
    public DfsObjDatabase getObjectDatabase() {
        return this.objdb;
    }

    @Override
    public DfsRefDatabase getRefDatabase() {
        return this.refdb;
    }

    private class MemRefDatabase
    extends DfsRefDatabase {
        private final ConcurrentMap<String, Ref> refs;

        MemRefDatabase() {
            super(InMemoryRepository.this);
            this.refs = new ConcurrentHashMap<String, Ref>();
        }

        @Override
        protected DfsRefDatabase.RefCache scanAllRefs() throws IOException {
            RefList.Builder<Ref> ids = new RefList.Builder<Ref>();
            RefList.Builder<Ref> sym = new RefList.Builder<Ref>();
            for (Ref ref : this.refs.values()) {
                if (ref.isSymbolic()) {
                    sym.add(ref);
                }
                ids.add(ref);
            }
            ids.sort();
            sym.sort();
            return new DfsRefDatabase.RefCache(ids.toRefList(), sym.toRefList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean compareAndPut(Ref oldRef, Ref newRef) throws IOException {
            ObjectId id = newRef.getObjectId();
            if (id != null) {
                RevWalk rw = new RevWalk(this.getRepository());
                try {
                    rw.parseAny(id);
                }
                finally {
                    rw.close();
                }
            }
            String name = newRef.getName();
            if (oldRef == null) {
                return this.refs.putIfAbsent(name, newRef) == null;
            }
            ConcurrentMap<String, Ref> concurrentMap = this.refs;
            synchronized (concurrentMap) {
                Ref cur;
                Ref toCompare = cur = (Ref)this.refs.get(name);
                if (toCompare != null) {
                    if (toCompare.isSymbolic()) {
                        Ref leaf = toCompare.getLeaf();
                        if (leaf.getObjectId() == null) {
                            if ((leaf = (Ref)this.refs.get(leaf.getName())).isSymbolic()) {
                                throw new IllegalArgumentException();
                            }
                            toCompare = new SymbolicRef(name, new ObjectIdRef.Unpeeled(Ref.Storage.NEW, leaf.getName(), leaf.getObjectId()));
                        } else {
                            toCompare = toCompare.getLeaf();
                        }
                    }
                    if (this.eq(toCompare, oldRef)) {
                        return this.refs.replace(name, cur, newRef);
                    }
                }
            }
            if (oldRef.getStorage() == Ref.Storage.NEW) {
                return this.refs.putIfAbsent(name, newRef) == null;
            }
            return false;
        }

        @Override
        protected boolean compareAndRemove(Ref oldRef) throws IOException {
            String name = oldRef.getName();
            Ref cur = (Ref)this.refs.get(name);
            if (cur != null && this.eq(cur, oldRef)) {
                return this.refs.remove(name, cur);
            }
            return false;
        }

        private boolean eq(Ref a, Ref b) {
            if (!Objects.equals(a.getName(), b.getName())) {
                return false;
            }
            return Objects.equals(a.getLeaf().getObjectId(), b.getLeaf().getObjectId());
        }
    }

    private static class ByteArrayReadableChannel
    implements ReadableChannel {
        private final byte[] data;
        private int position;
        private boolean open = true;

        ByteArrayReadableChannel(byte[] buf) {
            this.data = buf;
        }

        @Override
        public int read(ByteBuffer dst) {
            int n = Math.min(dst.remaining(), this.data.length - this.position);
            if (n == 0) {
                return -1;
            }
            dst.put(this.data, this.position, n);
            this.position += n;
            return n;
        }

        @Override
        public void close() {
            this.open = false;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public long position() {
            return this.position;
        }

        @Override
        public void position(long newPosition) {
            this.position = (int)newPosition;
        }

        @Override
        public long size() {
            return this.data.length;
        }

        @Override
        public int blockSize() {
            return 0;
        }

        @Override
        public void setReadAheadBytes(int b) {
        }
    }

    private static abstract class Out
    extends DfsOutputStream {
        private final ByteArrayOutputStream dst = new ByteArrayOutputStream();
        private byte[] data;

        private Out() {
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.data = null;
            this.dst.write(buf, off, len);
        }

        @Override
        public int read(long position, ByteBuffer buf) {
            byte[] d = this.getData();
            int n = Math.min(buf.remaining(), d.length - (int)position);
            if (n == 0) {
                return -1;
            }
            buf.put(d, (int)position, n);
            return n;
        }

        byte[] getData() {
            if (this.data == null) {
                this.data = this.dst.toByteArray();
            }
            return this.data;
        }

        @Override
        public abstract void flush();

        @Override
        public void close() {
            this.flush();
        }
    }

    private static class MemPack
    extends DfsPackDescription {
        private final Map<PackExt, byte[]> fileMap = new HashMap<PackExt, byte[]>();

        MemPack(String name, DfsRepositoryDescription repoDesc) {
            super(repoDesc, name);
        }
    }

    private class MemObjDatabase
    extends DfsObjDatabase {
        private List<DfsPackDescription> packs;

        MemObjDatabase(DfsRepository repo) {
            super(repo, new DfsReaderOptions());
            this.packs = new ArrayList<DfsPackDescription>();
        }

        @Override
        protected synchronized List<DfsPackDescription> listPacks() {
            return this.packs;
        }

        @Override
        protected DfsPackDescription newPack(DfsObjDatabase.PackSource source) {
            int id = packId.incrementAndGet();
            MemPack desc = new MemPack("pack-" + id + "-" + source.name(), this.getRepository().getDescription());
            return desc.setPackSource(source);
        }

        @Override
        protected synchronized void commitPackImpl(Collection<DfsPackDescription> desc, Collection<DfsPackDescription> replace) {
            ArrayList<DfsPackDescription> n = new ArrayList<DfsPackDescription>(desc.size() + this.packs.size());
            n.addAll(desc);
            n.addAll(this.packs);
            if (replace != null) {
                n.removeAll(replace);
            }
            this.packs = n;
        }

        @Override
        protected void rollbackPack(Collection<DfsPackDescription> desc) {
        }

        @Override
        protected ReadableChannel openFile(DfsPackDescription desc, PackExt ext) throws FileNotFoundException, IOException {
            MemPack memPack = (MemPack)desc;
            byte[] file = (byte[])memPack.fileMap.get(ext);
            if (file == null) {
                throw new FileNotFoundException(desc.getFileName(ext));
            }
            return new ByteArrayReadableChannel(file);
        }

        @Override
        protected DfsOutputStream writeFile(DfsPackDescription desc, final PackExt ext) throws IOException {
            final MemPack memPack = (MemPack)desc;
            return new Out(){

                @Override
                public void flush() {
                    memPack.fileMap.put(ext, this.getData());
                }
            };
        }
    }

    public static class Builder
    extends DfsRepositoryBuilder<Builder, InMemoryRepository> {
        @Override
        public InMemoryRepository build() throws IOException {
            return new InMemoryRepository(this);
        }
    }
}

