/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMerger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MergingFileDescription<T extends DomElement>
extends DomFileDescription<T> {
    private ModelMerger myMerger;

    protected MergingFileDescription(Class<T> rootElementClass, @NonNls String rootTagName) {
        super(rootElementClass, rootTagName, new String[0]);
    }

    @NotNull
    protected abstract Set<XmlFile> getFilesToMerge(DomElement var1);

    @Override
    @NotNull
    public DomElement getResolveScope(GenericDomValue<?> reference) {
        DomElement annotation = this.getScopeFromAnnotation(reference);
        if (annotation != null) {
            DomElement domElement = annotation;
            if (domElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/MergingFileDescription", "getResolveScope"));
            }
            return domElement;
        }
        DomFileElement element = DomUtil.getFileElement(reference);
        Object t = this.getMergedRoot(element);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/MergingFileDescription", "getResolveScope"));
        }
        return t;
    }

    public final T getMergedRoot(DomFileElement<T> element) {
        DomFileElement originalElement;
        DomManager domManager = element.getManager();
        XmlFile xmlFile = element.getFile();
        HashSet<XmlFile> files = new HashSet<XmlFile>();
        files.add(xmlFile);
        XmlFile originalFile = (XmlFile)xmlFile.getOriginalFile();
        if (originalFile != xmlFile && (originalElement = domManager.getFileElement(originalFile)) != null) {
            element = originalElement;
        }
        files.addAll(this.getFilesToMerge(element));
        ArrayList roots = new ArrayList(files.size());
        for (XmlFile file : files) {
            DomFileElement fileElement = domManager.getFileElement(file);
            if (fileElement == null) continue;
            roots.add(fileElement.getRootElement());
        }
        if (roots.size() == 1) {
            return (T)((DomElement)roots.iterator().next());
        }
        if (this.myMerger == null) {
            this.myMerger = DomService.getInstance().createModelMerger();
        }
        return (T)((DomElement)this.myMerger.mergeModels(this.getRootElementClass(), roots));
    }

    @Override
    @NotNull
    public DomElement getIdentityScope(DomElement element) {
        DomElement annotation = this.getScopeFromAnnotation(element);
        if (annotation != null) {
            DomElement domElement = annotation;
            if (domElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/MergingFileDescription", "getIdentityScope"));
            }
            return domElement;
        }
        List<JavaMethod> methods = DomUtil.getFixedPath(element.getParent());
        if (methods == null) {
            DomElement domElement = super.getIdentityScope(element);
            if (domElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/MergingFileDescription", "getIdentityScope"));
            }
            return domElement;
        }
        DomFileElement root = DomUtil.getFileElement(element);
        Object o = this.getMergedRoot(root);
        for (JavaMethod method : methods) {
            o = method.invoke(o, ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        DomElement domElement = (DomElement)o;
        if (domElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/MergingFileDescription", "getIdentityScope"));
        }
        return domElement;
    }

    @Override
    public boolean isAutomaticHighlightingEnabled() {
        return false;
    }
}

