/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.mac.MacMessages;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MessageDialogBuilder<T extends MessageDialogBuilder> {
    protected final String myMessage;
    protected final String myTitle;
    protected String myYesText;
    protected String myNoText;
    protected Project myProject;
    protected Icon myIcon;
    protected DialogWrapper.DoNotAskOption myDoNotAskOption;

    private MessageDialogBuilder(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/MessageDialogBuilder", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/ui/MessageDialogBuilder", "<init>"));
        }
        this.myTitle = title;
        this.myMessage = message;
    }

    @NotNull
    public static YesNo yesNo(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/MessageDialogBuilder", "yesNo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/ui/MessageDialogBuilder", "yesNo"));
        }
        YesNo yesNo = (YesNo)new YesNo(title, message).icon(Messages.getQuestionIcon());
        if (yesNo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MessageDialogBuilder", "yesNo"));
        }
        return yesNo;
    }

    public static YesNoCancel yesNoCancel(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/MessageDialogBuilder", "yesNoCancel"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/ui/MessageDialogBuilder", "yesNoCancel"));
        }
        return (YesNoCancel)new YesNoCancel(title, message).icon(Messages.getQuestionIcon());
    }

    protected abstract T getThis();

    @NotNull
    public T project(@Nullable Project project) {
        this.myProject = project;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MessageDialogBuilder", "project"));
        }
        return t;
    }

    public T icon(@Nullable Icon icon) {
        this.myIcon = icon;
        return this.getThis();
    }

    @NotNull
    public T doNotAsk(@NotNull DialogWrapper.DoNotAskOption doNotAskOption) {
        if (doNotAskOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doNotAskOption", "com/intellij/openapi/ui/MessageDialogBuilder", "doNotAsk"));
        }
        this.myDoNotAskOption = doNotAskOption;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MessageDialogBuilder", "doNotAsk"));
        }
        return t;
    }

    public T yesText(@NotNull String yesText) {
        if (yesText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yesText", "com/intellij/openapi/ui/MessageDialogBuilder", "yesText"));
        }
        this.myYesText = yesText;
        return this.getThis();
    }

    public T noText(@NotNull String noText) {
        if (noText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noText", "com/intellij/openapi/ui/MessageDialogBuilder", "noText"));
        }
        this.myNoText = noText;
        return this.getThis();
    }

    public static final class YesNoCancel
    extends MessageDialogBuilder<YesNoCancel> {
        private String myCancelText;

        private YesNoCancel(@NotNull String title, @NotNull String message) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/MessageDialogBuilder$YesNoCancel", "<init>"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/ui/MessageDialogBuilder$YesNoCancel", "<init>"));
            }
            super(title, message);
        }

        public YesNoCancel cancelText(@NotNull String cancelText) {
            if (cancelText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelText", "com/intellij/openapi/ui/MessageDialogBuilder$YesNoCancel", "cancelText"));
            }
            this.myCancelText = cancelText;
            return this.getThis();
        }

        @Override
        protected YesNoCancel getThis() {
            return this;
        }

        @Messages.YesNoCancelResult
        public int show() {
            String yesText = (String)ObjectUtils.chooseNotNull((Object)this.myYesText, (Object)Messages.YES_BUTTON);
            String noText = (String)ObjectUtils.chooseNotNull((Object)this.myNoText, (Object)Messages.NO_BUTTON);
            String cancelText = (String)ObjectUtils.chooseNotNull((Object)this.myCancelText, (Object)Messages.CANCEL_BUTTON);
            try {
                if (Messages.canShowMacSheetPanel() && !Messages.isApplicationInUnitTestOrHeadless()) {
                    return MacMessages.getInstance().showYesNoCancelDialog(this.myTitle, this.myMessage, yesText, noText, cancelText, WindowManager.getInstance().suggestParentWindow(this.myProject), this.myDoNotAskOption);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            int buttonNumber = Messages.showDialog(this.myProject, this.myMessage, this.myTitle, new String[]{yesText, noText, cancelText}, 0, this.myIcon, this.myDoNotAskOption);
            return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
        }
    }

    public static final class YesNo
    extends MessageDialogBuilder<YesNo> {
        private YesNo(@NotNull String title, @NotNull String message) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/MessageDialogBuilder$YesNo", "<init>"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/ui/MessageDialogBuilder$YesNo", "<init>"));
            }
            super(title, message);
        }

        @Override
        protected YesNo getThis() {
            return this;
        }

        @Messages.YesNoResult
        public int show() {
            String yesText = (String)ObjectUtils.chooseNotNull((Object)this.myYesText, (Object)Messages.YES_BUTTON);
            String noText = (String)ObjectUtils.chooseNotNull((Object)this.myNoText, (Object)Messages.NO_BUTTON);
            try {
                if (Messages.canShowMacSheetPanel() && !Messages.isApplicationInUnitTestOrHeadless()) {
                    return MacMessages.getInstance().showYesNoDialog(this.myTitle, this.myMessage, yesText, noText, WindowManager.getInstance().suggestParentWindow(this.myProject), this.myDoNotAskOption);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Messages.showDialog(this.myProject, this.myMessage, this.myTitle, new String[]{yesText, noText}, 0, this.myIcon, this.myDoNotAskOption) == 0 ? 0 : 1;
        }

        public boolean is() {
            return this.show() == 0;
        }
    }
}

