/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.parameterInfo;

import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoUtils {
    public static final String DEFAULT_PARAMETER_CLOSE_CHARS = ",){}";

    @Nullable
    public static <T extends PsiElement> T findParentOfType(PsiFile file, int offset, Class<T> parentClass) {
        return ParameterInfoUtils.findParentOfTypeWithStopElements(file, offset, parentClass, new Class[0]);
    }

    @Nullable
    public static <T extends PsiElement> T findParentOfTypeWithStopElements(PsiFile file, int offset, Class<T> parentClass, Class<? extends PsiElement> ... stopAt) {
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/lang/parameterInfo/ParameterInfoUtils", "findParentOfTypeWithStopElements"));
        }
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        T parentOfType = PsiTreeUtil.getParentOfType(element, parentClass, true, stopAt);
        if (element instanceof PsiWhiteSpace) {
            parentOfType = PsiTreeUtil.getParentOfType(PsiTreeUtil.prevLeaf(element), parentClass, true, stopAt);
        }
        return parentOfType;
    }

    public static int getCurrentParameterIndex(ASTNode argList, int offset, IElementType delimiterType) {
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.astTraverser(argList).expandAndSkip(Conditions.is((Object)argList));
        return ParameterInfoUtils.getCurrentParameterIndex(s, offset, delimiterType);
    }

    public static <V> int getCurrentParameterIndex(SyntaxTraverser<V> s, int offset, IElementType delimiterType) {
        Object child;
        Object root = s.getRoot();
        int curOffset = s.api.rangeOf(root).getStartOffset();
        if (offset < curOffset) {
            return -1;
        }
        int index = 0;
        Iterator iterator = s.iterator();
        while (iterator.hasNext() && offset >= (curOffset += s.api.rangeOf(child = iterator.next()).getLength())) {
            IElementType type = s.api.typeOf(child);
            if (type != delimiterType) continue;
            ++index;
        }
        return index;
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file, int offset, int lbraceOffset, @NotNull ParameterInfoHandlerWithTabActionSupport findArgumentListHelper) {
        PsiElement element;
        int offset1;
        if (findArgumentListHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findArgumentListHelper", "com/intellij/lang/parameterInfo/ParameterInfoUtils", "findArgumentList"));
        }
        if (file == null) {
            return null;
        }
        CharSequence chars = file.getViewProvider().getContents();
        if (offset >= chars.length()) {
            offset = chars.length() - 1;
        }
        if ((offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)offset, (String)" \t\n\r")) < 0) {
            return null;
        }
        boolean acceptRparenth = true;
        boolean acceptLparenth = false;
        if (offset1 != offset) {
            offset = offset1;
            acceptRparenth = false;
            acceptLparenth = true;
        }
        if ((element = file.findElementAt(offset)) == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        while (true) {
            if (findArgumentListHelper.getArgumentListClass().isInstance(parent)) {
                TextRange range = parent.getTextRange();
                if (!acceptRparenth && offset == range.getEndOffset() - 1) {
                    PsiElement[] children = parent.getChildren();
                    if (children.length == 0) {
                        return null;
                    }
                    PsiElement last = children[children.length - 1];
                    if (last.getNode().getElementType() == findArgumentListHelper.getActualParametersRBraceType()) {
                        parent = parent.getParent();
                        continue;
                    }
                }
                if (!acceptLparenth && offset == range.getStartOffset()) {
                    parent = parent.getParent();
                    continue;
                }
                if (lbraceOffset < 0 || range.getStartOffset() == lbraceOffset) break;
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof PsiFile || parent == null) {
                return null;
            }
            Set<Class> set = findArgumentListHelper.getArgListStopSearchClasses();
            for (Class aClass : set) {
                if (!aClass.isInstance(parent)) continue;
                return null;
            }
            parent = parent.getParent();
        }
        PsiElement listParent = parent.getParent();
        for (Class c : findArgumentListHelper.getArgumentListAllowedParentClasses()) {
            if (!c.isInstance(listParent)) continue;
            return (E)parent;
        }
        return null;
    }
}

