/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilderFactory;
import com.intellij.ide.util.projectWizard.ModuleBuilderListener;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleBuilder
extends AbstractModuleBuilder {
    public static final ExtensionPointName<ModuleBuilderFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.moduleBuilder");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.ModuleBuilder");
    private final Set<ModuleConfigurationUpdater> myUpdaters = new HashSet<ModuleConfigurationUpdater>();
    private final EventDispatcher<ModuleBuilderListener> myDispatcher = EventDispatcher.create(ModuleBuilderListener.class);
    protected Sdk myJdk;
    private String myName;
    @NonNls
    private String myModuleFilePath;
    private String myContentEntryPath;

    @NotNull
    public static List<ModuleBuilder> getAllBuilders() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ModuleType moduleType : ModuleTypeManager.getInstance().getRegisteredTypes()) {
            result.add(moduleType.createModuleBuilder());
        }
        for (ModuleBuilderFactory moduleBuilderFactory : (ModuleBuilderFactory[])EP_NAME.getExtensions()) {
            result.add(moduleBuilderFactory.createBuilder());
        }
        List list = ContainerUtil.filter(result, (Condition)new Condition<ModuleBuilder>(){

            public boolean value(ModuleBuilder moduleBuilder) {
                return moduleBuilder.isAvailable();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/ModuleBuilder", "getAllBuilders"));
        }
        return list;
    }

    public static void deleteModuleFile(String moduleFilePath) {
        VirtualFile file;
        File moduleFile = new File(moduleFilePath);
        if (moduleFile.exists()) {
            FileUtil.delete((File)moduleFile);
        }
        if ((file = LocalFileSystem.getInstance().findFileByIoFile(moduleFile)) != null) {
            file.refresh(false, false);
        }
    }

    protected boolean isAvailable() {
        return true;
    }

    @Nullable
    protected final String acceptParameter(String param) {
        return param != null && param.length() > 0 ? param : null;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String name) {
        this.myName = this.acceptParameter(name);
    }

    @Override
    @Nullable
    public String getBuilderId() {
        ModuleType moduleType = this.getModuleType();
        return moduleType == null ? null : moduleType.getId();
    }

    @Override
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/ide/util/projectWizard/ModuleBuilder", "createWizardSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/ide/util/projectWizard/ModuleBuilder", "createWizardSteps"));
        }
        ModuleType moduleType = this.getModuleType();
        return moduleType == null ? ModuleWizardStep.EMPTY_ARRAY : moduleType.createWizardSteps(wizardContext, this, modulesProvider);
    }

    @Override
    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/ide/util/projectWizard/ModuleBuilder", "modifySettingsStep"));
        }
        return this.modifyStep(settingsStep);
    }

    public ModuleWizardStep modifyStep(SettingsStep settingsStep) {
        ModuleType type = this.getModuleType();
        if (type == null) {
            return null;
        }
        final ModuleWizardStep step = type.modifySettingsStep(settingsStep, this);
        final List<WizardInputField> fields = this.getAdditionalFields();
        for (WizardInputField field : fields) {
            field.addToSettings(settingsStep);
        }
        return new ModuleWizardStep(){

            @Override
            public JComponent getComponent() {
                return null;
            }

            @Override
            public void updateDataModel() {
                if (step != null) {
                    step.updateDataModel();
                }
            }

            @Override
            public boolean validate() throws ConfigurationException {
                for (WizardInputField field : fields) {
                    if (field.validate()) continue;
                    return false;
                }
                return step == null || step.validate();
            }
        };
    }

    @Override
    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/ide/util/projectWizard/ModuleBuilder", "modifyProjectTypeStep"));
        }
        ModuleType type = this.getModuleType();
        return type == null ? null : type.modifyProjectTypeStep(settingsStep, this);
    }

    protected List<WizardInputField> getAdditionalFields() {
        return Collections.emptyList();
    }

    public String getModuleFilePath() {
        return this.myModuleFilePath;
    }

    @Override
    public void setModuleFilePath(@NonNls String path2) {
        this.myModuleFilePath = this.acceptParameter(path2);
    }

    public void addModuleConfigurationUpdater(ModuleConfigurationUpdater updater) {
        this.myUpdaters.add(updater);
    }

    @Nullable
    public String getContentEntryPath() {
        if (this.myContentEntryPath == null) {
            String directory = this.getModuleFileDirectory();
            if (directory == null) {
                return null;
            }
            new File(directory).mkdirs();
            return directory;
        }
        return this.myContentEntryPath;
    }

    @Override
    public void setContentEntryPath(String moduleRootPath) {
        String path2 = this.acceptParameter(moduleRootPath);
        if (path2 != null) {
            try {
                this.myContentEntryPath = FileUtil.resolveShortWindowsName((String)path2);
            }
            catch (IOException e) {
                this.myContentEntryPath = path2;
            }
        } else {
            this.myContentEntryPath = null;
        }
        if (this.myContentEntryPath != null) {
            this.myContentEntryPath = this.myContentEntryPath.replace(File.separatorChar, '/');
        }
    }

    @Nullable
    protected ContentEntry doAddContentEntry(ModifiableRootModel modifiableRootModel) {
        String contentEntryPath = this.getContentEntryPath();
        if (contentEntryPath == null) {
            return null;
        }
        new File(contentEntryPath).mkdirs();
        VirtualFile moduleContentRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(contentEntryPath.replace('\\', '/'));
        if (moduleContentRoot == null) {
            return null;
        }
        return modifiableRootModel.addContentEntry(moduleContentRoot);
    }

    @Nullable
    public String getModuleFileDirectory() {
        if (this.myModuleFilePath == null) {
            return null;
        }
        String parent = new File(this.myModuleFilePath).getParent();
        if (parent == null) {
            return null;
        }
        return parent.replace(File.separatorChar, '/');
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/ide/util/projectWizard/ModuleBuilder", "createModule"));
        }
        LOG.assertTrue(this.myName != null);
        LOG.assertTrue(this.myModuleFilePath != null);
        ModuleBuilder.deleteModuleFile(this.myModuleFilePath);
        ModuleType moduleType = this.getModuleType();
        Module module = moduleModel.newModule(this.myModuleFilePath, moduleType.getId());
        this.setupModule(module);
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/ModuleBuilder", "createModule"));
        }
        return module2;
    }

    protected void setupModule(Module module) throws ConfigurationException {
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance(module).getModifiableModel();
        this.setupRootModel(modifiableModel);
        for (ModuleConfigurationUpdater updater : this.myUpdaters) {
            updater.update(module, modifiableModel);
        }
        modifiableModel.commit();
        this.setProjectType(module);
    }

    private void onModuleInitialized(Module module) {
        ((ModuleBuilderListener)this.myDispatcher.getMulticaster()).moduleCreated(module);
    }

    public abstract void setupRootModel(ModifiableRootModel var1) throws ConfigurationException;

    public abstract ModuleType getModuleType();

    protected ProjectType getProjectType() {
        return null;
    }

    protected void setProjectType(Module module) {
        ProjectType projectType = this.getProjectType();
        if (projectType != null && ProjectTypeService.getProjectType(module.getProject()) == null) {
            ProjectTypeService.setProjectType(module.getProject(), projectType);
        }
    }

    @NotNull
    public Module createAndCommitIfNeeded(@NotNull Project project, @Nullable ModifiableModuleModel model, boolean runFromProjectWizard) throws InvalidDataException, ConfigurationException, IOException, JDOMException, ModuleWithNameAlreadyExists {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/projectWizard/ModuleBuilder", "createAndCommitIfNeeded"));
        }
        ModifiableModuleModel moduleModel = model != null ? model : ModuleManager.getInstance(project).getModifiableModel();
        final Module module = this.createModule(moduleModel);
        if (model == null) {
            moduleModel.commit();
        }
        if (runFromProjectWizard) {
            StartupManager.getInstance(module.getProject()).runWhenProjectIsInitialized(new DumbAwareRunnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            ModuleBuilder.this.onModuleInitialized(module);
                        }
                    });
                }
            });
        } else {
            this.onModuleInitialized(module);
        }
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/ModuleBuilder", "createAndCommitIfNeeded"));
        }
        return module2;
    }

    public void addListener(ModuleBuilderListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(ModuleBuilderListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public boolean canCreateModule() {
        return true;
    }

    @Override
    @Nullable
    public List<Module> commit(@NotNull Project project, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/projectWizard/ModuleBuilder", "commit"));
        }
        Module module = this.commitModule(project, model);
        return module != null ? Collections.singletonList(module) : null;
    }

    @Nullable
    public Module commitModule(final @NotNull Project project, final @Nullable ModifiableModuleModel model) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/projectWizard/ModuleBuilder", "commitModule"));
        }
        if (this.canCreateModule()) {
            if (this.myName == null) {
                this.myName = project.getName();
            }
            if (this.myModuleFilePath == null) {
                this.myModuleFilePath = project.getBaseDir().getPath() + File.separator + this.myName + ".iml";
            }
            try {
                return ApplicationManager.getApplication().runWriteAction(new ThrowableComputable<Module, Exception>(){

                    public Module compute() throws Exception {
                        return ModuleBuilder.this.createAndCommitIfNeeded(project, model, true);
                    }
                });
            }
            catch (Exception ex) {
                LOG.warn((Throwable)ex);
                Messages.showErrorDialog(IdeBundle.message("error.adding.module.to.project", ex.getMessage()), IdeBundle.message("title.add.module", new Object[0]));
            }
        }
        return null;
    }

    public Icon getBigIcon() {
        return this.getModuleType().getBigIcon();
    }

    @Override
    public Icon getNodeIcon() {
        return this.getModuleType().getNodeIcon(false);
    }

    public String getDescription() {
        return this.getModuleType().getDescription();
    }

    public String getPresentableName() {
        return this.getModuleTypeName();
    }

    protected String getModuleTypeName() {
        String name = this.getModuleType().getName();
        return StringUtil.trimEnd((String)name, (String)" Module");
    }

    public String getGroupName() {
        return this.getPresentableName().split(" ")[0];
    }

    public String getParentGroup() {
        return null;
    }

    public int getWeight() {
        return 0;
    }

    public boolean isTemplate() {
        return false;
    }

    public boolean isTemplateBased() {
        return false;
    }

    public void updateFrom(ModuleBuilder from) {
        this.myName = from.getName();
        this.myContentEntryPath = from.getContentEntryPath();
        this.myModuleFilePath = from.getModuleFilePath();
    }

    public Sdk getModuleJdk() {
        return this.myJdk;
    }

    public void setModuleJdk(Sdk jdk) {
        this.myJdk = jdk;
    }

    @NotNull
    public FrameworkRole getDefaultAcceptableRole() {
        FrameworkRole frameworkRole = this.getModuleType().getDefaultAcceptableRole();
        if (frameworkRole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/ModuleBuilder", "getDefaultAcceptableRole"));
        }
        return frameworkRole;
    }

    public static abstract class ModuleConfigurationUpdater {
        public abstract void update(@NotNull Module var1, @NotNull ModifiableRootModel var2);
    }
}

