/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class HighlighterFactory {
    private HighlighterFactory() {
    }

    @NotNull
    public static EditorHighlighter createHighlighter(SyntaxHighlighter highlighter, @NotNull EditorColorsScheme settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(highlighter, settings);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public static EditorHighlighter createHighlighter(Project project, @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileName);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public static EditorHighlighter createHighlighter(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public static EditorHighlighter createHighlighter(Project project, @NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public static EditorHighlighter createHighlighter(@NotNull EditorColorsScheme settings, @NotNull String fileName, Project project) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(settings, fileName, project);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public static EditorHighlighter createHighlighter(@NotNull FileType fileType, @NotNull EditorColorsScheme settings, Project project) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(fileType, settings, project);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        return editorHighlighter;
    }

    @NotNull
    public static EditorHighlighter createHighlighter(@NotNull VirtualFile vFile, @NotNull EditorColorsScheme settings, Project project) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(vFile, settings, project);
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HighlighterFactory", "createHighlighter"));
        }
        return editorHighlighter;
    }
}

