/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.caches;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileContent
extends UserDataHolderBase {
    private final VirtualFile myVirtualFile;
    private byte[] myCachedBytes;
    private long myCachedLength;
    private long myCachedTimeStamp;
    private Boolean myCachedWritable;

    public FileContent(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/caches/FileContent", "<init>"));
        }
        this.myCachedLength = -1L;
        this.myCachedTimeStamp = -1L;
        this.myVirtualFile = virtualFile;
    }

    public void cache() throws IOException {
        this.getBytes();
        this.getLength();
        this.getTimeStamp();
        this.isWritable();
    }

    @NotNull
    public byte[] getBytes() throws IOException {
        if (this.myCachedBytes == null) {
            byte[] byArray = this.myCachedBytes = this.myVirtualFile.isValid() ? this.myVirtualFile.contentsToByteArray(false) : ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        if (this.myCachedBytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/caches/FileContent", "getBytes"));
        }
        return this.myCachedBytes;
    }

    public void setEmptyContent() {
        this.myCachedBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
        this.myCachedLength = 0L;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/caches/FileContent", "getVirtualFile"));
        }
        return virtualFile;
    }

    public long getLength() {
        if (this.myCachedLength == -1L) {
            this.myCachedLength = this.myVirtualFile.getLength();
        }
        return this.myCachedLength;
    }

    public long getTimeStamp() {
        if (this.myCachedTimeStamp == -1L) {
            this.myCachedTimeStamp = this.myVirtualFile.getTimeStamp();
        }
        return this.myCachedTimeStamp;
    }

    public boolean isWritable() {
        if (this.myCachedWritable == null) {
            this.myCachedWritable = this.myVirtualFile.isWritable();
        }
        return this.myCachedWritable == Boolean.TRUE;
    }
}

