/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;

public class Facet<C extends FacetConfiguration>
extends UserDataHolderBase
implements UserDataHolder,
Disposable {
    public static final Facet[] EMPTY_ARRAY = new Facet[0];
    @NotNull
    private final FacetType myFacetType;
    @NotNull
    private final Module myModule;
    @NotNull
    private final C myConfiguration;
    private final Facet myUnderlyingFacet;
    private String myName;
    private boolean isDisposed;

    public Facet(@NotNull FacetType facetType, @NotNull Module module, @NotNull String name, @NotNull C configuration, Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/facet/Facet", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/facet/Facet", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/facet/Facet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/facet/Facet", "<init>"));
        }
        this.myName = name;
        this.myFacetType = facetType;
        this.myModule = module;
        this.myConfiguration = configuration;
        this.myUnderlyingFacet = underlyingFacet;
        Disposer.register((Disposable)this.myModule, (Disposable)this);
    }

    @NotNull
    public final FacetType getType() {
        FacetType facetType = this.myFacetType;
        if (facetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/Facet", "getType"));
        }
        return facetType;
    }

    public final FacetTypeId getTypeId() {
        return this.myFacetType.getId();
    }

    public final Facet getUnderlyingFacet() {
        return this.myUnderlyingFacet;
    }

    @NotNull
    public final C getConfiguration() {
        C c = this.myConfiguration;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/Facet", "getConfiguration"));
        }
        return c;
    }

    @NotNull
    public final Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/Facet", "getModule"));
        }
        return module;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void initFacet() {
    }

    public void disposeFacet() {
    }

    public final void dispose() {
        assert (!this.isDisposed);
        this.isDisposed = true;
        this.disposeFacet();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @NotNull
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/Facet", "getName"));
        }
        return string;
    }

    final void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/facet/Facet", "setName"));
        }
        this.myName = name;
    }

    public String toString() {
        return this.getName() + " (" + this.getModule().getName() + ")";
    }
}

