/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandLineState
implements RunProfileState {
    private TextConsoleBuilder myConsoleBuilder;
    private final ExecutionEnvironment myEnvironment;

    protected CommandLineState(ExecutionEnvironment environment) {
        this.myEnvironment = environment;
        if (this.myEnvironment != null) {
            Project project = this.myEnvironment.getProject();
            GlobalSearchScope searchScope = SearchScopeProvider.createSearchScope(project, this.myEnvironment.getRunProfile());
            this.myConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project, searchScope);
        }
    }

    public ExecutionEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    public RunnerSettings getRunnerSettings() {
        return this.myEnvironment.getRunnerSettings();
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = this.myEnvironment.getExecutionTarget();
        if (executionTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/CommandLineState", "getExecutionTarget"));
        }
        return executionTarget;
    }

    public void addConsoleFilters(Filter ... filters) {
        this.myConsoleBuilder.filters(filters);
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/configurations/CommandLineState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/execution/configurations/CommandLineState", "execute"));
        }
        ProcessHandler processHandler = this.startProcess();
        ConsoleView console = this.createConsole(executor);
        if (console != null) {
            console.attachToProcess(processHandler);
        }
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(console, processHandler, this.createActions(console, processHandler, executor));
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/CommandLineState", "execute"));
        }
        return defaultExecutionResult;
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/configurations/CommandLineState", "createConsole"));
        }
        TextConsoleBuilder builder = this.getConsoleBuilder();
        return builder != null ? builder.getConsole() : null;
    }

    @NotNull
    protected abstract ProcessHandler startProcess() throws ExecutionException;

    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler) {
        return this.createActions(console, processHandler, null);
    }

    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        if (console == null || !console.canPause() || executor != null && !DefaultRunExecutor.EXECUTOR_ID.equals(executor.getId())) {
            return new AnAction[0];
        }
        return new AnAction[]{new PauseOutputAction(console, processHandler)};
    }

    public TextConsoleBuilder getConsoleBuilder() {
        return this.myConsoleBuilder;
    }

    public void setConsoleBuilder(TextConsoleBuilder consoleBuilder) {
        this.myConsoleBuilder = consoleBuilder;
    }

    protected static class PauseOutputAction
    extends ToggleAction
    implements DumbAware {
        private final ConsoleView myConsole;
        private final ProcessHandler myProcessHandler;

        public PauseOutputAction(ConsoleView console, ProcessHandler processHandler) {
            super(ExecutionBundle.message("run.configuration.pause.output.action.name", new Object[0]), null, AllIcons.Actions.Pause);
            this.myConsole = console;
            this.myProcessHandler = processHandler;
        }

        @Override
        public boolean isSelected(AnActionEvent event) {
            return this.myConsole.isOutputPaused();
        }

        @Override
        public void setSelected(final AnActionEvent event, boolean flag) {
            this.myConsole.setOutputPaused(flag);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    PauseOutputAction.this.update(event);
                }
            });
        }

        @Override
        public void update(final AnActionEvent event) {
            boolean isRunning;
            super.update(event);
            Presentation presentation = event.getPresentation();
            boolean bl = isRunning = this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
            if (isRunning) {
                presentation.setEnabled(true);
            } else {
                if (!this.myConsole.canPause()) {
                    presentation.setEnabled(false);
                    return;
                }
                if (!this.myConsole.hasDeferredOutput()) {
                    presentation.setEnabled(false);
                } else {
                    presentation.setEnabled(true);
                    this.myConsole.performWhenNoDeferredOutput(new Runnable(){

                        @Override
                        public void run() {
                            PauseOutputAction.this.update(event);
                        }
                    });
                }
            }
        }
    }
}

