/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class UnfocusedNameIdentifier
extends CompletionConfidence {
    @Override
    @NotNull
    public ThreeState shouldFocusLookup(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/UnfocusedNameIdentifier", "shouldFocusLookup"));
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent instanceof PsiNameIdentifierOwner) {
            PsiElement nameIdentifier = ((PsiNameIdentifierOwner)parent).getNameIdentifier();
            if (nameIdentifier == position) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/UnfocusedNameIdentifier", "shouldFocusLookup"));
                }
                return threeState;
            }
            if (nameIdentifier != null && position.getTextRange().equals((Object)nameIdentifier.getTextRange())) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/UnfocusedNameIdentifier", "shouldFocusLookup"));
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/UnfocusedNameIdentifier", "shouldFocusLookup"));
        }
        return threeState;
    }
}

