/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.editor.IgnoredPropertiesFilesSuffixesManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleEditorConfigurable
extends BaseConfigurable {
    private final JPanel myPanel;
    private final CollectionListModel<String> mySuffixesModel;
    private final IgnoredPropertiesFilesSuffixesManager mySuffixesManager;

    public ResourceBundleEditorConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/ResourceBundleEditorConfigurable", "<init>"));
        }
        this.mySuffixesManager = IgnoredPropertiesFilesSuffixesManager.getInstance(project);
        final JBList list = new JBList();
        ArrayList<String> suffixes = new ArrayList<String>(this.mySuffixesManager.getIgnoredSuffixes());
        this.mySuffixesModel = new CollectionListModel(suffixes);
        this.mySuffixesModel.sort(String.CASE_INSENSITIVE_ORDER);
        list.setModel(this.mySuffixesModel);
        this.myPanel = ToolbarDecorator.createDecorator((JList)list).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String result = Messages.showInputDialog((Project)((Project)CommonDataKeys.PROJECT.getData(button.getDataContext())), (String)"Suffixes to ignore (use comma to separate suffixes):", (String)"Add Ignored Suffixes", null);
                if (result != null) {
                    List suffixes = StringUtil.split((String)result, (String)",");
                    for (String suffix : suffixes) {
                        if (ResourceBundleEditorConfigurable.this.mySuffixesModel.getElementIndex((Object)suffix) != -1) continue;
                        ResourceBundleEditorConfigurable.this.mySuffixesModel.add((Object)suffix);
                    }
                    ResourceBundleEditorConfigurable.this.updateModifiedStatus();
                    ResourceBundleEditorConfigurable.this.mySuffixesModel.sort(String.CASE_INSENSITIVE_ORDER);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                for (Object toDelete : list.getSelectedValues()) {
                    ResourceBundleEditorConfigurable.this.mySuffixesModel.remove((Object)((String)toDelete));
                }
                ResourceBundleEditorConfigurable.this.updateModifiedStatus();
            }
        }).createPanel();
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(JList list, String suffix, int index, boolean selected, boolean hasFocus) {
                this.append(suffix);
                Locale locale = PropertiesUtil.getLocale("_" + suffix + ".properties");
                if (locale != PropertiesUtil.DEFAULT_LOCALE && PropertiesUtil.hasDefaultLanguage(locale)) {
                    this.append(" ");
                    this.append(PropertiesUtil.getPresentableLocale(locale), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        });
        this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Ignored properties file suffixes:"));
    }

    @Nls
    public String getDisplayName() {
        return "Resource Bundle Editor";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public void apply() throws ConfigurationException {
        this.mySuffixesManager.setSuffixes(this.mySuffixesModel.getItems());
        this.setModified(false);
    }

    public void reset() {
        this.mySuffixesModel.removeAll();
        for (String suffix : this.mySuffixesManager.getIgnoredSuffixes()) {
            this.mySuffixesModel.add((Object)suffix);
        }
        this.mySuffixesModel.sort(String.CASE_INSENSITIVE_ORDER);
        this.setModified(false);
    }

    public void disposeUIResources() {
    }

    private void updateModifiedStatus() {
        this.setModified(!ContainerUtil.newHashSet((Iterable)this.mySuffixesModel.getItems()).equals(this.mySuffixesManager.getIgnoredSuffixes()));
    }

    public static class Provider
    extends ConfigurableProvider {
        private final Project myProject;

        public Provider(Project project) {
            this.myProject = project;
        }

        @Nullable
        public Configurable createConfigurable() {
            return new ResourceBundleEditorConfigurable(this.myProject);
        }
    }
}

