/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.ConditionalTemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateBasedProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.internal.Factory;

public class LanguageLibraryProjectInitDescriptor
extends TemplateBasedProjectInitDescriptor {
    private final String language;
    private final FileResolver fileResolver;
    private final TemplateOperationFactory templateOperationFactory;

    public LanguageLibraryProjectInitDescriptor(String language, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver) {
        this.language = language;
        this.fileResolver = fileResolver;
        this.templateOperationFactory = templateOperationFactory;
    }

    protected TemplateOperation whenNoSourcesAvailable(TemplateOperation ... operations) {
        return new ConditionalTemplateOperation(new Factory<Boolean>(){

            public Boolean create() {
                return LanguageLibraryProjectInitDescriptor.this.fileResolver.resolveFilesAsTree(new Object[]{String.format("src/main/%s", LanguageLibraryProjectInitDescriptor.this.language)}).isEmpty() || LanguageLibraryProjectInitDescriptor.this.fileResolver.resolveFilesAsTree(new Object[]{String.format("src/test/%s", LanguageLibraryProjectInitDescriptor.this.language)}).isEmpty();
            }
        }, operations);
    }

    protected TemplateOperation fromClazzTemplate(String clazzTemplate, String sourceSetName) {
        String targetFileName = clazzTemplate.substring(clazzTemplate.lastIndexOf("/") + 1).replace(".template", "");
        return this.templateOperationFactory.newTemplateOperation().withTemplate(clazzTemplate).withTarget(String.format("src/%s/%s/%s", sourceSetName, this.language, targetFileName)).create();
    }
}

