/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import org.gradle.model.InvalidModelRuleException;
import org.gradle.model.ModelRuleBindingException;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.report.AmbiguousBindingReporter;

abstract class ModelBinding {
    final BindingPredicate predicate;
    final ModelRuleDescriptor referrer;
    final boolean writable;
    protected ModelNodeInternal boundTo;

    protected ModelBinding(ModelRuleDescriptor referrer, BindingPredicate predicate, boolean writable) {
        this.predicate = predicate;
        this.referrer = referrer;
        this.writable = writable;
    }

    public BindingPredicate getPredicate() {
        return this.predicate;
    }

    public boolean isBound() {
        return this.boundTo != null;
    }

    public ModelNodeInternal getNode() {
        if (this.boundTo == null) {
            throw new IllegalStateException("Target node has not been bound.");
        }
        return this.boundTo;
    }

    boolean isTypeCompatible(ModelPromise promise) {
        return this.predicate.isUntyped() || promise.canBeViewedAsMutable(this.predicate.getType()) || promise.canBeViewedAsImmutable(this.predicate.getType());
    }

    public String toString() {
        return "ModelBinding{predicate=" + this.predicate + ", node=" + this.boundTo + '}';
    }

    public abstract boolean canBindInState(ModelNode.State var1);

    public final void onBind(ModelNodeInternal node) {
        if (this.boundTo != null) {
            ModelRuleDescriptor creatorDescriptor = node.getDescriptor();
            ModelPath path = node.getPath();
            throw new InvalidModelRuleException(this.referrer, (Throwable)((Object)new ModelRuleBindingException(new AmbiguousBindingReporter(this.predicate.getReference(), this.boundTo.getPath(), this.boundTo.getDescriptor(), path, creatorDescriptor).asString())));
        }
        this.doOnBind(node);
    }

    protected void doOnBind(ModelNodeInternal node) {
    }

    public void onUnbind(ModelNodeInternal node) {
        if (node == this.boundTo) {
            this.boundTo = null;
        }
    }
}

