/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViewFactory;
import org.gradle.model.internal.core.ModelViewState;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.TypedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ProjectionOnlyNodeInitializer;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.schema.CollectionSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.extract.CollectionNodeInitializerExtractionSupport;
import org.gradle.model.internal.manage.schema.extract.ScalarTypes;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarCollectionNodeInitializerExtractionStrategy
extends CollectionNodeInitializerExtractionSupport {
    public static final List<ModelType<?>> TYPES = ImmutableList.of(ModelType.of(List.class), ModelType.of(Set.class));

    @Override
    protected <T, E> NodeInitializer extractNodeInitializer(CollectionSchema<T, E> schema) {
        ModelType type = schema.getType();
        Class rawClass = type.getRawClass();
        ModelType rawCollectionType = ModelType.of(rawClass);
        if (TYPES.contains(rawCollectionType) && ScalarTypes.isScalarType(schema.getElementType())) {
            if (schema.getType().getRawClass() == List.class) {
                return new ProjectionOnlyNodeInitializer(ScalarCollectionModelProjection.get(ModelTypes.list(schema.getElementType()), new ListViewFactory<E>(schema.getElementType())));
            }
            return new ProjectionOnlyNodeInitializer(ScalarCollectionModelProjection.get(ModelTypes.set(schema.getElementType()), new SetViewFactory<E>(schema.getElementType())));
        }
        return null;
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableList.copyOf(TYPES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetBackedCollection<T>
    extends NodeBackedCollection<T, Set<T>>
    implements Set<T> {
        public SetBackedCollection(MutableModelNode modelNode, ModelViewState state, ModelType<T> elementType) {
            super(modelNode, state, elementType);
        }

        @Override
        protected Set<T> createPrivateData(boolean mutable) {
            if (mutable) {
                return Sets.newLinkedHashSet();
            }
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListBackedCollection<T>
    extends NodeBackedCollection<T, List<T>>
    implements List<T> {
        public ListBackedCollection(MutableModelNode modelNode, ModelViewState state, ModelType<T> elementType) {
            super(modelNode, state, elementType);
        }

        @Override
        protected List<T> createPrivateData(boolean mutable) {
            if (mutable) {
                return Lists.newArrayList();
            }
            return Collections.emptyList();
        }

        @Override
        public void add(int index, T element) {
            this.validateElementType(element);
            ((List)this.getDelegate(true)).add(index, element);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            this.validateCollection(c);
            return ((List)this.getDelegate(true)).addAll(index, c);
        }

        @Override
        public T get(int index) {
            return (T)((List)this.getDelegate(false)).get(index);
        }

        @Override
        public int indexOf(Object o) {
            return ((List)this.getDelegate(false)).indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((List)this.getDelegate(false)).lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return ((List)this.getDelegate(false)).listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return ((List)this.getDelegate(false)).listIterator(index);
        }

        @Override
        public T remove(int index) {
            return (T)((List)this.getDelegate(true)).remove(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int index, T element) {
            this.validateElementType(element);
            return ((List)this.getDelegate(true)).set(index, element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class NodeBackedCollection<T, C extends Collection<T>>
    implements Collection<T>,
    ManagedInstance {
        private final MutableModelNode modelNode;
        private final ModelViewState state;
        private final ModelType<T> elementType;

        public NodeBackedCollection(MutableModelNode modelNode, ModelViewState state, ModelType<T> elementType) {
            this.modelNode = modelNode;
            this.state = state;
            this.elementType = elementType;
        }

        protected C getDelegate(boolean write) {
            if (write) {
                this.state.assertCanMutate();
            }
            Collection delegate = (Collection)Cast.uncheckedCast(ScalarCollectionSchema.get(this.modelNode));
            return this.initialValue(write, delegate);
        }

        protected abstract C createPrivateData(boolean var1);

        private C initialValue(boolean write, Collection<T> delegate) {
            if (delegate == null) {
                if (write) {
                    delegate = this.createPrivateData(true);
                    ScalarCollectionSchema.set(this.modelNode, delegate);
                } else {
                    delegate = this.createPrivateData(false);
                }
            }
            return (C)((Collection)Cast.uncheckedCast(delegate));
        }

        @Override
        public MutableModelNode getBackingNode() {
            return this.modelNode;
        }

        @Override
        public ModelType<?> getManagedType() {
            return ModelType.of(this.getClass());
        }

        protected void validateElementType(Object o) {
            ModelType<?> obType;
            if (o != null && !(obType = ModelType.of(o.getClass())).equals(this.elementType)) {
                throw new IllegalArgumentException(String.format("Cannot add an element of type %s to a collection of %s", obType, this.elementType));
            }
        }

        protected void validateCollection(Collection<? extends T> c) {
            for (T element : c) {
                this.validateElementType(element);
            }
        }

        @Override
        public boolean add(T t) {
            this.validateElementType(t);
            return this.getDelegate(true).add(t);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            this.validateCollection(c);
            return this.getDelegate(true).addAll(c);
        }

        @Override
        public void clear() {
            this.getDelegate(true).clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.getDelegate(false).contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.getDelegate(false).containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return this.getDelegate(false).equals(o);
        }

        @Override
        public int hashCode() {
            return this.getDelegate(false).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.getDelegate(false).isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return new MutationSafeIterator(this.getDelegate(false).iterator());
        }

        @Override
        public boolean remove(Object o) {
            return this.getDelegate(true).remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.getDelegate(true).removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.getDelegate(true).retainAll(c);
        }

        @Override
        public int size() {
            return this.getDelegate(false).size();
        }

        @Override
        public Object[] toArray() {
            return this.getDelegate(false).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getDelegate(false).toArray(a);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class MutationSafeIterator
        implements Iterator<T> {
            private final Iterator<T> delegate;

            private MutationSafeIterator(Iterator<T> delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public T next() {
                return this.delegate.next();
            }

            @Override
            public void remove() {
                NodeBackedCollection.this.state.assertCanMutate();
                this.delegate.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetViewFactory<T>
    implements ModelViewFactory<Set<T>> {
        private final ModelType<T> elementType;

        public SetViewFactory(ModelType<T> elementType) {
            this.elementType = elementType;
        }

        @Override
        public ModelView<Set<T>> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean writable) {
            ModelType<Set<T>> setType = ModelTypes.set(this.elementType);
            DefaultModelViewState state = new DefaultModelViewState(setType, ruleDescriptor, writable, !writable);
            SetBackedCollection<T> set = new SetBackedCollection<T>(modelNode, state, this.elementType);
            return InstanceModelView.of(modelNode.getPath(), setType, set, state.closer());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListViewFactory that = (ListViewFactory)o;
            return this.elementType.equals(that.elementType);
        }

        public int hashCode() {
            return this.elementType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListViewFactory<T>
    implements ModelViewFactory<List<T>> {
        private final ModelType<T> elementType;

        public ListViewFactory(ModelType<T> elementType) {
            this.elementType = elementType;
        }

        @Override
        public ModelView<List<T>> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean writable) {
            ModelType<List<T>> listType = ModelTypes.list(this.elementType);
            DefaultModelViewState state = new DefaultModelViewState(listType, ruleDescriptor, writable, !writable);
            ListBackedCollection<T> list = new ListBackedCollection<T>(modelNode, state, this.elementType);
            return InstanceModelView.of(modelNode.getPath(), listType, list, state.closer());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListViewFactory that = (ListViewFactory)o;
            return this.elementType.equals(that.elementType);
        }

        public int hashCode() {
            return this.elementType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScalarCollectionModelProjection<E>
    extends TypedModelProjection<E> {
        public static <E, U extends Collection<E>> ScalarCollectionModelProjection<U> get(ModelType<U> type, ModelViewFactory<U> viewFactory) {
            return new ScalarCollectionModelProjection<U>(type, viewFactory);
        }

        public ScalarCollectionModelProjection(ModelType<E> type, ModelViewFactory<E> viewFactory) {
            super(type, viewFactory, true, true);
        }

        @Override
        public Optional<String> getValueDescription(MutableModelNode modelNodeInternal) {
            Collection values = ScalarCollectionSchema.get(modelNodeInternal);
            if (values == null) {
                return Optional.absent();
            }
            return Optional.of((Object)values.toString());
        }
    }
}

