/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import groovy.lang.GroovyObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.MethodSignatureEquivalence;
import org.gradle.model.Managed;
import org.gradle.model.internal.manage.schema.extract.CandidateMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSchemaUtils {
    private static final Equivalence<Method> METHOD_EQUIVALENCE = new MethodSignatureEquivalence();
    private static final Set<Equivalence.Wrapper<Method>> IGNORED_METHODS = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.concat(Arrays.asList(Object.class.getMethods()), Arrays.asList(GroovyObject.class.getMethods())), (Function)new Function<Method, Equivalence.Wrapper<Method>>(){

        public Equivalence.Wrapper<Method> apply(@Nullable Method input) {
            return METHOD_EQUIVALENCE.wrap((Object)input);
        }
    }));

    public static <T> CandidateMethods getCandidateMethods(Class<T> clazz) {
        final ImmutableListMultimap.Builder methodsByNameBuilder = ImmutableListMultimap.builder();
        ModelSchemaUtils.walkTypeHierarchy(clazz, new TypeVisitor<T>(){

            @Override
            public void visitType(Class<? super T> type) {
                Method[] declaredMethods = type.getDeclaredMethods();
                Arrays.sort(declaredMethods, Ordering.usingToString());
                for (Method method : declaredMethods) {
                    if (ModelSchemaUtils.isIgnoredMethod(method)) continue;
                    methodsByNameBuilder.put((Object)method.getName(), (Object)method);
                }
            }
        });
        ImmutableListMultimap methodsByName = methodsByNameBuilder.build();
        ImmutableSortedMap.Builder candidatesBuilder = ImmutableSortedMap.naturalOrder();
        for (String methodName : methodsByName.keySet()) {
            ImmutableList methodsWithSameName = methodsByName.get((Object)methodName);
            ImmutableListMultimap equivalenceIndex = Multimaps.index((Iterable)methodsWithSameName, (Function)new Function<Method, Equivalence.Wrapper<Method>>(){

                public Equivalence.Wrapper<Method> apply(Method method) {
                    return METHOD_EQUIVALENCE.wrap((Object)method);
                }
            });
            candidatesBuilder.put((Object)methodName, (Object)equivalenceIndex.asMap());
        }
        return new CandidateMethods((Map<String, Map<Equivalence.Wrapper<Method>, Collection<Method>>>)candidatesBuilder.build());
    }

    public static boolean isIgnoredMethod(Method method) {
        int modifiers = method.getModifiers();
        if (method.isSynthetic() || Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            return true;
        }
        return IGNORED_METHODS.contains(METHOD_EQUIVALENCE.wrap((Object)method));
    }

    public static <T> void walkTypeHierarchy(Class<T> clazz, TypeVisitor<? extends T> visitor) {
        Class type;
        HashSet seenInterfaces = Sets.newHashSet();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(clazz);
        while ((type = (Class)queue.poll()) != null) {
            if (type.equals(Object.class) || type.equals(GroovyObject.class)) continue;
            visitor.visitType(type);
            Class superclass = type.getSuperclass();
            if (superclass != null) {
                queue.add(superclass);
            }
            for (Class<?> iface : type.getInterfaces()) {
                if (!seenInterfaces.add(iface)) continue;
                queue.add(Cast.uncheckedCast(iface));
            }
        }
    }

    public static Method findMostSpecificMethod(Iterable<Method> declaringMethods) {
        for (Method method : declaringMethods) {
            if (Proxy.isProxyClass(method.getDeclaringClass())) continue;
            return method;
        }
        throw new IllegalArgumentException("Cannot find most-specific declaration of method. Declarations checked: " + declaringMethods);
    }

    public static boolean isMethodDeclaredInManagedType(Iterable<Method> declarations) {
        Method mostSpecificDeclaration = ModelSchemaUtils.findMostSpecificMethod(declarations);
        return ModelSchemaUtils.isMethodDeclaredInManagedType(mostSpecificDeclaration);
    }

    public static boolean isMethodDeclaredInManagedType(Method method) {
        return method.getDeclaringClass().isAnnotationPresent(Managed.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TypeVisitor<T> {
        public void visitType(Class<? super T> var1);
    }
}

