/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.Actions;
import org.gradle.internal.BiAction;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.model.internal.core.AddProjectionsAction;
import org.gradle.model.internal.core.DefaultModelRegistration;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class ModelRegistrations {
    public static <T> Builder serviceInstance(ModelReference<T> modelReference, T instance) {
        return ModelRegistrations.bridgedInstance(modelReference, instance).service(true);
    }

    public static <T> Builder bridgedInstance(ModelReference<T> modelReference, T instance) {
        return ModelRegistrations.unmanagedInstance(modelReference, Factories.constant(instance), (Action<? super MutableModelNode>)Actions.doNothing());
    }

    public static <T> Builder unmanagedInstance(ModelReference<T> modelReference, Factory<? extends T> factory) {
        return ModelRegistrations.unmanagedInstance(modelReference, factory, (Action<? super MutableModelNode>)Actions.doNothing());
    }

    public static <T> Builder unmanagedInstance(ModelReference<T> modelReference, final Factory<? extends T> factory, final Action<? super MutableModelNode> initializer) {
        return ModelRegistrations.unmanagedInstanceOf(modelReference, new Transformer<T, MutableModelNode>(){

            public T transform(MutableModelNode modelNode) {
                Object t = factory.create();
                initializer.execute((Object)modelNode);
                return t;
            }
        });
    }

    public static <T> Builder unmanagedInstanceOf(final ModelReference<T> modelReference, final Transformer<? extends T, ? super MutableModelNode> factory) {
        return ModelRegistrations.of(modelReference.getPath(), (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

            public void execute(MutableModelNode modelNode) {
                Object t = factory.transform((Object)modelNode);
                modelNode.setPrivateData(modelReference.getType(), t);
            }
        }).withProjection(UnmanagedModelProjection.of(modelReference.getType()));
    }

    public static Builder of(ModelPath path) {
        return new Builder(path);
    }

    public static Builder of(ModelPath path, NodeInitializer initializer) {
        return new Builder(path, initializer);
    }

    public static Builder of(ModelPath path, ModelReference<?> input, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
        return ModelRegistrations.of(path, Collections.singletonList(input), initializer);
    }

    public static Builder of(ModelPath path, List<? extends ModelReference<?>> inputs, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
        return new Builder(path).action(ModelActionRole.Create, inputs, initializer);
    }

    public static Builder of(ModelPath path, Action<? super MutableModelNode> initializer) {
        return new Builder(path).action(ModelActionRole.Create, initializer);
    }

    public static <T> Builder of(final ModelReference<T> modelReference, final Factory<? extends T> factory) {
        return ModelRegistrations.of(modelReference.getPath(), (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

            public void execute(MutableModelNode modelNode) {
                Object value = factory.create();
                modelNode.setPrivateData(modelReference.getType(), value);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public static class Builder {
        private final ModelReference<?> reference;
        private final List<ModelProjection> projections = new ArrayList<ModelProjection>();
        private final ListMultimap<ModelActionRole, ModelAction> actions = ArrayListMultimap.create();
        private final NodeInitializer nodeInitializer;
        private final DescriptorReference descriptorReference = new DescriptorReference();
        private boolean service;
        private boolean ephemeral;
        private boolean hidden;

        private Builder(ModelPath path) {
            this(path, (NodeInitializer)null);
        }

        private Builder(ModelPath path, NodeInitializer nodeInitializer) {
            this.reference = ModelReference.of(path);
            this.nodeInitializer = nodeInitializer;
        }

        public Builder descriptor(String descriptor) {
            return this.descriptor(new SimpleModelRuleDescriptor(descriptor));
        }

        public Builder descriptor(ModelRuleDescriptor descriptor) {
            this.descriptorReference.descriptor = descriptor;
            return this;
        }

        public Builder descriptor(ModelRuleDescriptor parent, ModelRuleDescriptor child) {
            return this.descriptor(new NestedModelRuleDescriptor(parent, child));
        }

        public Builder descriptor(ModelRuleDescriptor parent, String child) {
            return this.descriptor(new NestedModelRuleDescriptor(parent, new SimpleModelRuleDescriptor(child)));
        }

        public Builder action(ModelActionRole role, ModelAction action) {
            this.actions.put((Object)role, (Object)action);
            return this;
        }

        public Builder action(ModelActionRole role, Action<? super MutableModelNode> action) {
            return this.action(role, new NoInputsBuilderAction(this.reference, this.descriptorReference, action));
        }

        public Builder action(ModelActionRole role, Iterable<? extends ModelReference<?>> inputs, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> action) {
            return this.action(role, new InputsUsingBuilderAction(this.reference, this.descriptorReference, inputs, action));
        }

        public Builder withProjection(ModelProjection projection) {
            this.projections.add(projection);
            return this;
        }

        public Builder hidden(boolean flag) {
            this.hidden = flag;
            return this;
        }

        public Builder ephemeral(boolean flag) {
            this.ephemeral = flag;
            return this;
        }

        public Builder service(boolean flag) {
            this.service = flag;
            return this;
        }

        public ModelRegistration build() {
            ModelRuleDescriptor descriptor = this.descriptorReference.descriptor;
            if (this.nodeInitializer != null) {
                this.actions.putAll(this.nodeInitializer.getActions(this.reference, descriptor));
            }
            if (!this.projections.isEmpty()) {
                this.action(ModelActionRole.Discover, AddProjectionsAction.of(this.reference, descriptor, this.projections));
            }
            return new DefaultModelRegistration(this.reference.getPath(), descriptor, this.service, this.ephemeral || this.service, this.hidden || this.service, (Multimap<ModelActionRole, ? extends ModelAction>)this.actions);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class InputsUsingBuilderAction
        extends AbstractBuilderAction {
            private final List<ModelReference<?>> inputs;
            private final BiAction<? super MutableModelNode, ? super List<ModelView<?>>> action;

            public InputsUsingBuilderAction(ModelReference<?> subject, DescriptorReference descriptorReference, Iterable<? extends ModelReference<?>> inputs, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> action) {
                super(subject, descriptorReference);
                this.inputs = ImmutableList.copyOf(inputs);
                this.action = action;
            }

            @Override
            public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
                this.action.execute((Object)modelNode, inputs);
            }

            @Override
            public List<? extends ModelReference<?>> getInputs() {
                return this.inputs;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class NoInputsBuilderAction
        extends AbstractBuilderAction {
            private final Action<? super MutableModelNode> action;

            public NoInputsBuilderAction(ModelReference<?> subject, DescriptorReference descriptorReference, Action<? super MutableModelNode> action) {
                super(subject, descriptorReference);
                this.action = action;
            }

            @Override
            public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
                this.action.execute((Object)modelNode);
            }

            @Override
            public List<? extends ModelReference<?>> getInputs() {
                return Collections.emptyList();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static abstract class AbstractBuilderAction
        implements ModelAction {
            private final ModelReference<?> subject;
            private final DescriptorReference descriptorReference;

            public AbstractBuilderAction(ModelReference<?> subject, DescriptorReference descriptorReference) {
                this.subject = subject;
                this.descriptorReference = descriptorReference;
            }

            @Override
            public ModelReference<?> getSubject() {
                return this.subject;
            }

            @Override
            public ModelRuleDescriptor getDescriptor() {
                return this.descriptorReference.descriptor;
            }
        }

        private static class DescriptorReference {
            private ModelRuleDescriptor descriptor;

            private DescriptorReference() {
            }
        }
    }
}

