/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.internal.BiAction;
import org.gradle.internal.Cast;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.core.DirectNodeInputUsingModelAction;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractManagedModelInitializer;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.projection.ManagedModelProjection;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryBasedNodeInitializer<T, S extends T>
extends AbstractManagedModelInitializer<S> {
    private final InstanceFactory<T> instanceFactory;

    public FactoryBasedNodeInitializer(InstanceFactory<T> instanceFactory, StructSchema<S> modelSchema) {
        super(modelSchema);
        this.instanceFactory = instanceFactory;
    }

    @Override
    public Multimap<ModelActionRole, ModelAction> getActions(ModelReference<?> subject, ModelRuleDescriptor descriptor) {
        return ImmutableSetMultimap.builder().put((Object)ModelActionRole.Discover, (Object)DirectNodeInputUsingModelAction.of(subject, descriptor, Arrays.asList(ModelReference.of(ModelSchemaStore.class), ModelReference.of(ManagedProxyFactory.class), ModelReference.of(TypeConverter.class)), new BiAction<MutableModelNode, List<ModelView<?>>>(){

            public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                ModelSchemaStore schemaStore = ModelViews.getInstance(modelViews, 0, ModelSchemaStore.class);
                ManagedProxyFactory proxyFactory = ModelViews.getInstance(modelViews, 1, ManagedProxyFactory.class);
                TypeConverter typeConverter = ModelViews.getInstance(modelViews, 2, TypeConverter.class);
                ModelType publicType = FactoryBasedNodeInitializer.this.schema.getType();
                ModelType delegateType = FactoryBasedNodeInitializer.this.delegateTypeFor(publicType);
                ModelSchema delegateSchema = schemaStore.getSchema(delegateType);
                if (!(delegateSchema instanceof StructSchema)) {
                    throw new IllegalStateException(String.format("Default implementation '%s' registered for managed type '%s' must be a struct", delegateType, publicType));
                }
                StructSchema delegateStructSchema = (StructSchema)Cast.uncheckedCast(delegateSchema);
                FactoryBasedNodeInitializer.this.addProjection(modelNode, publicType, delegateStructSchema, schemaStore, proxyFactory, typeConverter);
                FactoryBasedNodeInitializer.this.addInternalViewProjections(modelNode, schemaStore, proxyFactory, typeConverter, publicType, delegateStructSchema);
            }
        })).put((Object)ModelActionRole.Create, (Object)DirectNodeInputUsingModelAction.of(subject, descriptor, Arrays.asList(ModelReference.of(NodeInitializerRegistry.class), ModelReference.of(ModelSchemaStore.class), ModelReference.of(ManagedProxyFactory.class), ModelReference.of(TypeConverter.class)), new BiAction<MutableModelNode, List<ModelView<?>>>(){

            public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                NodeInitializerRegistry nodeInitializerRegistry = ModelViews.getInstance(modelViews, 0, NodeInitializerRegistry.class);
                ModelSchemaStore schemaStore = ModelViews.getInstance(modelViews, 1, ModelSchemaStore.class);
                ManagedProxyFactory proxyFactory = ModelViews.getInstance(modelViews, 2, ManagedProxyFactory.class);
                TypeConverter typeConverter = ModelViews.getInstance(modelViews, 3, TypeConverter.class);
                ModelType type = FactoryBasedNodeInitializer.this.schema.getType();
                InstanceFactory.ImplementationInfo implementationInfo = FactoryBasedNodeInitializer.this.schema instanceof ManagedImplSchema ? FactoryBasedNodeInitializer.this.instanceFactory.getManagedSubtypeImplementationInfo(type) : FactoryBasedNodeInitializer.this.instanceFactory.getImplementationInfo(type);
                ModelType delegateType = (ModelType)Cast.uncheckedCast(implementationInfo.getDelegateType());
                Object instance = implementationInfo.create(modelNode);
                modelNode.setPrivateData(delegateType, instance);
                StructSchema delegateSchema = (StructSchema)Cast.uncheckedCast(schemaStore.getSchema(delegateType));
                FactoryBasedNodeInitializer.this.addPropertyLinks(modelNode, nodeInitializerRegistry, proxyFactory, FactoryBasedNodeInitializer.this.getProperties(delegateSchema, schemaStore), typeConverter);
                FactoryBasedNodeInitializer.this.hideNodesOfHiddenProperties(modelNode, FactoryBasedNodeInitializer.this.getHiddenProperties(delegateSchema, schemaStore));
            }
        })).build();
    }

    private void addInternalViewProjections(MutableModelNode modelNode, ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory, TypeConverter typeConverter, ModelType<S> publicType, StructSchema<? extends T> delegateStructSchema) {
        for (ModelType<?> internalView : this.internalViewsFor(publicType)) {
            this.addProjection(modelNode, internalView, delegateStructSchema, schemaStore, proxyFactory, typeConverter);
        }
    }

    private Set<ModelType<?>> internalViewsFor(ModelType<S> publicType) {
        return this.instanceFactory.getInternalViews(publicType);
    }

    private ModelType<? extends T> delegateTypeFor(ModelType<S> publicType) {
        if (this.schema instanceof ManagedImplSchema) {
            return this.instanceFactory.getManagedSubtypeImplementationInfo(publicType).getDelegateType();
        }
        return this.instanceFactory.getImplementationInfo(publicType).getDelegateType();
    }

    private Collection<ModelProperty<?>> getProperties(StructSchema<T> delegateSchema, ModelSchemaStore schemaStore) {
        ImmutableSet.Builder properties = ImmutableSet.builder();
        this.addNonDelegatedManagedProperties(this.schema, delegateSchema, properties);
        this.addInternalViewsProperties(delegateSchema, schemaStore, properties);
        return properties.build();
    }

    private Set<ModelProperty<?>> getHiddenProperties(StructSchema<T> delegateSchema, ModelSchemaStore schemaStore) {
        ImmutableSet.Builder pubPropsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder intPropsBuilder = ImmutableSet.builder();
        this.addNonDelegatedManagedProperties(this.schema, delegateSchema, pubPropsBuilder);
        this.addInternalViewsProperties(delegateSchema, schemaStore, intPropsBuilder);
        return Sets.difference((Set)intPropsBuilder.build(), (Set)pubPropsBuilder.build());
    }

    private void addInternalViewsProperties(StructSchema<T> delegateSchema, ModelSchemaStore schemaStore, ImmutableSet.Builder<ModelProperty<?>> properties) {
        for (ModelType<?> internalView : this.internalViewsFor(this.schema.getType())) {
            ModelSchema<?> internalViewSchema = schemaStore.getSchema(internalView);
            if (!(internalViewSchema instanceof StructSchema)) continue;
            this.addNonDelegatedManagedProperties((StructSchema)internalViewSchema, delegateSchema, properties);
        }
    }

    private void addNonDelegatedManagedProperties(StructSchema<?> schema, StructSchema<T> delegateSchema, ImmutableSet.Builder<ModelProperty<?>> properties) {
        for (ModelProperty<?> property : schema.getProperties()) {
            if (property.getStateManagementType() != ModelProperty.StateManagementType.MANAGED || delegateSchema.hasProperty(property.getName())) continue;
            properties.add(property);
        }
    }

    private void hideNodesOfHiddenProperties(MutableModelNode modelNode, Set<ModelProperty<?>> hiddenProps) {
        for (ModelProperty<?> hiddenProp : hiddenProps) {
            MutableModelNode hiddenPropNode = modelNode.getLink(hiddenProp.getName());
            if (hiddenPropNode == null) continue;
            hiddenPropNode.setHidden(true);
        }
    }

    private <D> void addProjection(MutableModelNode modelNode, ModelType<?> type, StructSchema<? extends D> delegateSchema, ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory, TypeConverter typeConverter) {
        ModelSchema<?> schema = schemaStore.getSchema(type);
        if (!(schema instanceof StructSchema)) {
            throw new IllegalStateException("View type must be a struct: " + type);
        }
        StructSchema structSchema = (StructSchema)Cast.uncheckedCast(schema);
        modelNode.addProjection(this.modelProjectionFor(structSchema, delegateSchema, proxyFactory, typeConverter));
    }

    private <D> ModelProjection modelProjectionFor(StructSchema<D> structSchema, StructSchema<? extends D> delegateSchema, ManagedProxyFactory proxyFactory, TypeConverter typeConverter) {
        return new ManagedModelProjection<D>(structSchema, delegateSchema, proxyFactory, typeConverter);
    }
}

