/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Arrays;
import java.util.List;
import org.gradle.model.internal.core.AbstractModelAction;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelActionWithView<T>
extends AbstractModelAction<T> {
    protected AbstractModelActionWithView(ModelReference<T> subject, ModelRuleDescriptor descriptor, ModelReference<?> ... inputs) {
        this(subject, descriptor, Arrays.asList(inputs));
    }

    protected AbstractModelActionWithView(ModelReference<T> subject, ModelRuleDescriptor descriptor, List<? extends ModelReference<?>> inputs) {
        super(subject, descriptor, inputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(MutableModelNode node, List<ModelView<?>> inputs) {
        if (!node.isAtLeast(ModelNode.State.Created)) {
            throw new IllegalStateException("Cannot get view for node " + node.getPath() + " in state " + (Object)((Object)node.getState()));
        }
        ModelType type = this.getSubject().getType();
        ModelView view = node.asMutable(type, this.getDescriptor(), inputs);
        if (view == null) {
            throw new IllegalArgumentException(String.format("Cannot project model element %s to writable type '%s' for rule %s", node.getPath(), type, this.getDescriptor()));
        }
        try {
            this.execute(node, view.getInstance(), inputs);
        }
        finally {
            view.close();
        }
    }

    protected abstract void execute(MutableModelNode var1, T var2, List<ModelView<?>> var3);
}

