/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.tasks.trello.TrelloRepository;
import com.intellij.tasks.trello.model.TrelloBoard;
import com.intellij.tasks.trello.model.TrelloList;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrelloRepositoryEditor
extends BaseRepositoryEditor<TrelloRepository> {
    private static final Logger LOG = Logger.getInstance(TrelloRepositoryEditor.class);
    private ComboBox myBoardComboBox;
    private ComboBox myListComboBox;
    private JBLabel myListLabel;
    private JBLabel myBoardLabel;
    private JBCheckBox myAllCardsCheckBox;

    public TrelloRepositoryEditor(Project project, TrelloRepository repository, Consumer<TrelloRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myUrlLabel.setVisible(false);
        this.myURLText.setVisible(false);
        this.myUsernameLabel.setVisible(false);
        this.myUserNameText.setVisible(false);
        this.myPasswordLabel.setText("Token:");
        this.myAllCardsCheckBox.setSelected(((TrelloRepository)this.myRepository).isIncludeAllCards());
        this.myPasswordText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String password = String.valueOf(TrelloRepositoryEditor.this.myPasswordText.getPassword());
                if (password.isEmpty() || password.equals(((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getPassword())) {
                    return;
                }
                ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setPassword(password);
                new BoardsComboBoxUpdater(){

                    @Override
                    @NotNull
                    protected List<TrelloBoard> fetch(@NotNull ProgressIndicator indicator) throws Exception {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/trello/TrelloRepositoryEditor$1$1", "fetch"));
                        }
                        ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentUser(((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchUserByToken());
                        Object object = super.fetch(indicator);
                        if (object == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepositoryEditor$1$1", "fetch"));
                        }
                        return object;
                    }
                }.queue();
                TrelloRepositoryEditor.this.doApply();
            }
        });
        this.myBoardComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TrelloBoard board = (TrelloBoard)e.getItem();
                if (e.getStateChange() == 2 || board.equals(((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentBoard())) {
                    return;
                }
                if (board != TrelloRepository.UNSPECIFIED_BOARD) {
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentBoard(board);
                    new ListsComboBoxUpdater(){

                        @Override
                        @Nullable
                        public TrelloList getSelectedItem() {
                            return TrelloRepository.UNSPECIFIED_LIST;
                        }
                    }.queue();
                } else {
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentBoard(null);
                    TrelloRepositoryEditor.this.myListComboBox.removeAllItems();
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentList(null);
                }
                TrelloRepositoryEditor.this.doApply();
            }
        });
        this.myBoardComboBox.setRenderer((ListCellRenderer)((Object)new TaskUiUtil.SimpleComboBoxRenderer<TrelloBoard>("Set token first"){

            @Override
            @NotNull
            protected String getDescription(@NotNull TrelloBoard board) {
                if (board == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "board", "com/intellij/tasks/trello/TrelloRepositoryEditor$3", "getDescription"));
                }
                String string = board.isClosed() ? board.getName() + " (closed)" : board.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepositoryEditor$3", "getDescription"));
                }
                return string;
            }
        }));
        this.myListComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TrelloList list = (TrelloList)e.getItem();
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentList(list);
                    TrelloRepositoryEditor.this.doApply();
                }
            }
        });
        this.myListComboBox.setRenderer((ListCellRenderer)((Object)new TaskUiUtil.SimpleComboBoxRenderer<TrelloList>("Select board first"){

            @Override
            @NotNull
            protected String getDescription(@NotNull TrelloList list) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/tasks/trello/TrelloRepositoryEditor$5", "getDescription"));
                }
                String text = list.getName();
                if (list.isClosed() && list.isMoved()) {
                    text = text + " (archived,moved)";
                } else if (list.isMoved()) {
                    text = text + " (moved)";
                } else if (list.isClosed()) {
                    text = text + " (archived)";
                }
                String string = text;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepositoryEditor$5", "getDescription"));
                }
                return string;
            }
        }));
        this.installListener((JCheckBox)this.myAllCardsCheckBox);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                TrelloRepositoryEditor.this.initialize();
            }
        });
    }

    private void initialize() {
        if (((TrelloRepository)this.myRepository).getCurrentUser() != null) {
            new BoardsComboBoxUpdater(){

                @Override
                @NotNull
                protected List<TrelloBoard> fetch(@NotNull ProgressIndicator indicator) throws Exception {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/trello/TrelloRepositoryEditor$7", "fetch"));
                    }
                    Object boards = super.fetch(indicator);
                    TrelloBoard currentBoard = this.getSelectedItem();
                    if (currentBoard != null && currentBoard != TrelloRepository.UNSPECIFIED_BOARD) {
                        int i = boards.indexOf(currentBoard);
                        currentBoard = i >= 0 ? (TrelloBoard)boards.get(i) : ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchBoardById(currentBoard.getId());
                        ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentBoard(currentBoard);
                    }
                    Object object = boards;
                    if (object == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepositoryEditor$7", "fetch"));
                    }
                    return object;
                }
            }.queue();
        }
        if (((TrelloRepository)this.myRepository).getCurrentBoard() != null && ((TrelloRepository)this.myRepository).getCurrentBoard() != TrelloRepository.UNSPECIFIED_BOARD) {
            new ListsComboBoxUpdater(){

                @Override
                @NotNull
                protected List<TrelloList> fetch(@NotNull ProgressIndicator indicator) throws Exception {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/trello/TrelloRepositoryEditor$8", "fetch"));
                    }
                    Object lists = super.fetch(indicator);
                    TrelloList currentList = ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentList();
                    if (currentList != null && currentList != TrelloRepository.UNSPECIFIED_LIST) {
                        int i = lists.indexOf(currentList);
                        currentList = i >= 0 ? (TrelloList)lists.get(i) : ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchListById(currentList.getId());
                        TrelloBoard currentBoard = ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentBoard();
                        if (currentBoard != null && !currentList.getIdBoard().equals(currentBoard.getId())) {
                            currentList.setMoved(true);
                        }
                        ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentList(currentList);
                    }
                    Object object = lists;
                    if (object == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepositoryEditor$8", "fetch"));
                    }
                    return object;
                }
            }.queue();
        }
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myBoardComboBox = new ComboBox(300);
        this.myBoardLabel = new JBLabel("Board:", 4);
        this.myBoardLabel.setLabelFor((Component)this.myBoardComboBox);
        this.myListComboBox = new ComboBox(300);
        this.myListLabel = new JBLabel("List:", 4);
        this.myListLabel.setLabelFor((Component)this.myListComboBox);
        this.myAllCardsCheckBox = new JBCheckBox("Include cards not assigned to me");
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myBoardLabel, (JComponent)this.myBoardComboBox).addLabeledComponent((JComponent)this.myListLabel, (JComponent)this.myListComboBox).addComponentToRightColumn((JComponent)this.myAllCardsCheckBox).getPanel();
    }

    public void apply() {
        super.apply();
        ((TrelloRepository)this.myRepository).setIncludeAllCards(this.myAllCardsCheckBox.isSelected());
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myListLabel.setAnchor(anchor);
        this.myBoardLabel.setAnchor(anchor);
    }

    private class ListsComboBoxUpdater
    extends TaskUiUtil.ComboBoxUpdater<TrelloList> {
        public ListsComboBoxUpdater() {
            super(TrelloRepositoryEditor.this.myProject, "Downloading Trello lists...", (JComboBox)TrelloRepositoryEditor.this.myListComboBox);
        }

        @Override
        @NotNull
        protected List<TrelloList> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/trello/TrelloRepositoryEditor$ListsComboBoxUpdater", "fetch"));
            }
            List<TrelloList> list = ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchBoardLists();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepositoryEditor$ListsComboBoxUpdater", "fetch"));
            }
            return list;
        }

        @Override
        @Nullable
        public TrelloList getExtraItem() {
            return TrelloRepository.UNSPECIFIED_LIST;
        }

        @Override
        @Nullable
        public TrelloList getSelectedItem() {
            return ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentList();
        }

        @Override
        protected boolean addSelectedItemIfMissing() {
            return true;
        }
    }

    private class BoardsComboBoxUpdater
    extends TaskUiUtil.ComboBoxUpdater<TrelloBoard> {
        public BoardsComboBoxUpdater() {
            super(TrelloRepositoryEditor.this.myProject, "Downloading Trello boards...", (JComboBox)TrelloRepositoryEditor.this.myBoardComboBox);
        }

        @Override
        @NotNull
        protected List<TrelloBoard> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/trello/TrelloRepositoryEditor$BoardsComboBoxUpdater", "fetch"));
            }
            List<TrelloBoard> list = ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchUserBoards();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepositoryEditor$BoardsComboBoxUpdater", "fetch"));
            }
            return list;
        }

        @Override
        @Nullable
        public TrelloBoard getExtraItem() {
            return TrelloRepository.UNSPECIFIED_BOARD;
        }

        @Override
        @Nullable
        public TrelloBoard getSelectedItem() {
            return ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentBoard();
        }

        @Override
        protected void handleError() {
            super.handleError();
            TrelloRepositoryEditor.this.myListComboBox.removeAllItems();
        }

        @Override
        protected boolean addSelectedItemIfMissing() {
            return true;
        }
    }
}

