/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateWarningDialog;
import java.security.cert.X509Certificate;
import java.util.List;

public class ShowCertificateInfoAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ShowCertificateInfoAction.class);

    public ShowCertificateInfoAction() {
        super("Show certificate information dialog");
    }

    public void actionPerformed(AnActionEvent e) {
        try {
            CertificateManager manager = CertificateManager.getInstance();
            List certificates = manager.getCustomTrustManager().getCertificates();
            if (certificates.isEmpty()) {
                Messages.showInfoMessage((String)String.format("Key store '%s' is empty", manager.getCacertsPath()), (String)"No Certificates Available");
            } else {
                CertificateWarningDialog dialog = CertificateWarningDialog.createUntrustedCertificateWarning((X509Certificate)((X509Certificate)certificates.get(0)));
                LOG.debug("Accepted: " + dialog.showAndGet());
            }
        }
        catch (Exception logged) {
            LOG.error((Throwable)logged);
        }
    }
}

