/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import java.util.ServiceLoader;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.annotation.TargetVersions;
import org.jetbrains.plugins.gradle.tooling.util.VersionMatcher;

public class ExtraModelBuilder
implements ToolingModelBuilder {
    private static ServiceLoader<ModelBuilderService> buildersLoader = ServiceLoader.load(ModelBuilderService.class, ExtraModelBuilder.class.getClassLoader());
    @NotNull
    private final GradleVersion myCurrentGradleVersion;

    public ExtraModelBuilder() {
        this.myCurrentGradleVersion = GradleVersion.current();
    }

    public ExtraModelBuilder(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder", "<init>"));
        }
        this.myCurrentGradleVersion = gradleVersion;
    }

    public boolean canBuild(String modelName) {
        for (ModelBuilderService service : buildersLoader) {
            if (!service.canBuild(modelName) || !this.isVersionMatch(service)) continue;
            return true;
        }
        return false;
    }

    public Object buildAll(String modelName, Project project) {
        for (ModelBuilderService service : buildersLoader) {
            if (!service.canBuild(modelName) || !this.isVersionMatch(service)) continue;
            try {
                return service.buildAll(modelName, project);
            }
            catch (Exception e) {
                ErrorMessageBuilder builderError = service.getErrorMessageBuilder(project, e);
                project.getLogger().error(builderError.build());
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported model: " + modelName);
    }

    private boolean isVersionMatch(@NotNull ModelBuilderService builderService) {
        if (builderService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderService", "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder", "isVersionMatch"));
        }
        TargetVersions targetVersions = builderService.getClass().getAnnotation(TargetVersions.class);
        return new VersionMatcher(this.myCurrentGradleVersion).isVersionMatch(targetVersions);
    }
}

