/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UnsafeBroadcastReceiverDetector
extends Detector
implements Detector.ClassScanner,
Detector.XmlScanner {
    public static final Issue ACTION_STRING = Issue.create((String)"UnsafeProtectedBroadcastReceiver", (String)"Unsafe Protected BroadcastReceiver", (String)"BroadcastReceivers that declare an intent-filter for a protected-broadcast action string must check that the received intent's action string matches the expected value, otherwise it is possible for malicious actors to spoof intents.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(UnsafeBroadcastReceiverDetector.class, EnumSet.of(Scope.MANIFEST, Scope.ALL_CLASS_FILES)));
    public static final Issue BROADCAST_SMS = Issue.create((String)"UnprotectedSMSBroadcastReceiver", (String)"Unprotected SMS BroadcastReceiver", (String)"BroadcastReceivers that declare an intent-filter for SMS_DELIVER or SMS_RECEIVED must ensure that the caller has the BROADCAST_SMS permission, otherwise it is possible for malicious actors to spoof intents.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(UnsafeBroadcastReceiverDetector.class, Scope.MANIFEST_SCOPE));
    private static final String[] PROTECTED_BROADCASTS = new String[]{"android.app.action.ENTER_CAR_MODE", "android.app.action.ENTER_DESK_MODE", "android.app.action.EXIT_CAR_MODE", "android.app.action.EXIT_DESK_MODE", "android.app.action.NEXT_ALARM_CLOCK_CHANGED", "android.appwidget.action.APPWIDGET_DELETED", "android.appwidget.action.APPWIDGET_DISABLED", "android.appwidget.action.APPWIDGET_ENABLED", "android.appwidget.action.APPWIDGET_HOST_RESTORED", "android.appwidget.action.APPWIDGET_RESTORED", "android.appwidget.action.APPWIDGET_UPDATE_OPTIONS", "android.backup.intent.CLEAR", "android.backup.intent.INIT", "android.backup.intent.RUN", "android.bluetooth.a2dp-sink.profile.action.AUDIO_CONFIG_CHANGED", "android.bluetooth.a2dp-sink.profile.action.CONNECTION_STATE_CHANGED", "android.bluetooth.a2dp-sink.profile.action.PLAYING_STATE_CHANGED", "android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED", "android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED", "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED", "android.bluetooth.adapter.action.DISCOVERY_FINISHED", "android.bluetooth.adapter.action.DISCOVERY_STARTED", "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED", "android.bluetooth.adapter.action.SCAN_MODE_CHANGED", "android.bluetooth.adapter.action.STATE_CHANGED", "android.bluetooth.avrcp-controller.profile.action.CONNECTION_STATE_CHANGED", "android.bluetooth.device.action.ACL_CONNECTED", "android.bluetooth.device.action.ACL_DISCONNECTED", "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED", "android.bluetooth.device.action.ALIAS_CHANGED", "android.bluetooth.device.action.BOND_STATE_CHANGED", "android.bluetooth.device.action.CLASS_CHANGED", "android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL", "android.bluetooth.device.action.CONNECTION_ACCESS_REPLY", "android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST", "android.bluetooth.device.action.DISAPPEARED", "android.bluetooth.device.action.FOUND", "android.bluetooth.device.action.MAS_INSTANCE", "android.bluetooth.device.action.NAME_CHANGED", "android.bluetooth.device.action.NAME_FAILED", "android.bluetooth.device.action.PAIRING_CANCEL", "android.bluetooth.device.action.PAIRING_REQUEST", "android.bluetooth.device.action.UUID", "android.bluetooth.devicepicker.action.DEVICE_SELECTED", "android.bluetooth.devicepicker.action.LAUNCH", "android.bluetooth.headset.action.VENDOR_SPECIFIC_HEADSET_EVENT", "android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED", "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED", "android.bluetooth.headsetclient.profile.action.AG_CALL_CHANGED", "android.bluetooth.headsetclient.profile.action.AG_EVENT", "android.bluetooth.headsetclient.profile.action.AUDIO_STATE_CHANGED", "android.bluetooth.headsetclient.profile.action.CONNECTION_STATE_CHANGED", "android.bluetooth.headsetclient.profile.action.LAST_VTAG", "android.bluetooth.headsetclient.profile.action.RESULT", "android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED", "android.bluetooth.input.profile.action.PROTOCOL_MODE_CHANGED", "android.bluetooth.input.profile.action.VIRTUAL_UNPLUG_STATUS", "android.bluetooth.pan.profile.action.CONNECTION_STATE_CHANGED", "android.bluetooth.pbap.intent.action.PBAP_STATE_CHANGED", "android.btopp.intent.action.CONFIRM", "android.btopp.intent.action.HIDE", "android.btopp.intent.action.HIDE_COMPLETE", "android.btopp.intent.action.INCOMING_FILE_NOTIFICATION", "android.btopp.intent.action.LIST", "android.btopp.intent.action.OPEN", "android.btopp.intent.action.OPEN_INBOUND", "android.btopp.intent.action.OPEN_OUTBOUND", "android.btopp.intent.action.RETRY", "android.btopp.intent.action.USER_CONFIRMATION_TIMEOUT", "android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED", "android.hardware.usb.action.USB_ACCESSORY_ATTACHED", "android.hardware.usb.action.USB_ACCESSORY_ATTACHED", "android.hardware.usb.action.USB_DEVICE_ATTACHED", "android.hardware.usb.action.USB_DEVICE_DETACHED", "android.hardware.usb.action.USB_STATE", "android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED", "android.intent.action.ACTION_DEFAULT_SMS_SUBSCRIPTION_CHANGED", "android.intent.action.ACTION_DEFAULT_SUBSCRIPTION_CHANGED", "android.intent.action.ACTION_DEFAULT_VOICE_SUBSCRIPTION_CHANGED", "android.intent.action.ACTION_IDLE_MAINTENANCE_END", "android.intent.action.ACTION_IDLE_MAINTENANCE_START", "android.intent.action.ACTION_MDN_STATE_CHANGED", "android.intent.action.ACTION_POWER_CONNECTED", "android.intent.action.ACTION_POWER_DISCONNECTED", "android.intent.action.ACTION_SET_RADIO_CAPABILITY_DONE", "android.intent.action.ACTION_SET_RADIO_CAPABILITY_FAILED", "android.intent.action.ACTION_SHOW_NOTICE_ECM_BLOCK_OTHERS", "android.intent.action.ACTION_SHUTDOWN", "android.intent.action.ACTION_SUBINFO_CONTENT_CHANGE", "android.intent.action.ACTION_SUBINFO_RECORD_UPDATED", "android.intent.action.ADVANCED_SETTINGS", "android.intent.action.AIRPLANE_MODE", "android.intent.action.ANY_DATA_STATE", "android.intent.action.APPLICATION_RESTRICTIONS_CHANGED", "android.intent.action.BATTERY_CHANGED", "android.intent.action.BATTERY_LOW", "android.intent.action.BATTERY_OKAY", "android.intent.action.BOOT_COMPLETED", "android.intent.action.BUGREPORT_FINISHED", "android.intent.action.CLEAR_DNS_CACHE", "android.intent.action.CONFIGURATION_CHANGED", "android.intent.action.DATA_CONNECTION_CONNECTED_TO_PROVISIONING_APN", "android.intent.action.DATA_CONNECTION_FAILED", "android.intent.action.DATE_CHANGED", "android.intent.action.DEVICE_STORAGE_FULL", "android.intent.action.DEVICE_STORAGE_LOW", "android.intent.action.DEVICE_STORAGE_NOT_FULL", "android.intent.action.DEVICE_STORAGE_OK", "android.intent.action.DOCK_EVENT", "android.intent.action.DREAMING_STARTED", "android.intent.action.DREAMING_STOPPED", "android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED", "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE", "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE", "android.intent.action.HDMI_PLUGGED", "android.intent.action.HEADSET_PLUG", "android.intent.action.LOCALE_CHANGED", "android.intent.action.MASTER_CLEAR_NOTIFICATION", "android.intent.action.MEDIA_BAD_REMOVAL", "android.intent.action.MEDIA_CHECKING", "android.intent.action.MEDIA_EJECT", "android.intent.action.MEDIA_MOUNTED", "android.intent.action.MEDIA_NOFS", "android.intent.action.MEDIA_REMOVED", "android.intent.action.MEDIA_SHARED", "android.intent.action.MEDIA_UNMOUNTABLE", "android.intent.action.MEDIA_UNMOUNTED", "android.intent.action.MEDIA_UNSHARED", "android.intent.action.MY_PACKAGE_REPLACED", "android.intent.action.NETWORK_SET_TIME", "android.intent.action.NETWORK_SET_TIMEZONE", "android.intent.action.NEW_OUTGOING_CALL", "android.intent.action.PACKAGE_ADDED", "android.intent.action.PACKAGE_CHANGED", "android.intent.action.PACKAGE_DATA_CLEARED", "android.intent.action.PACKAGE_FIRST_LAUNCH", "android.intent.action.PACKAGE_FULLY_REMOVED", "android.intent.action.PACKAGE_INSTALL", "android.intent.action.PACKAGE_NEEDS_VERIFICATION", "android.intent.action.PACKAGE_REMOVED", "android.intent.action.PACKAGE_REPLACED", "android.intent.action.PACKAGE_RESTARTED", "android.intent.action.PACKAGE_VERIFIED", "android.intent.action.PERMISSION_RESPONSE_RECEIVED", "android.intent.action.PHONE_STATE", "android.intent.action.PROXY_CHANGE", "android.intent.action.QUERY_PACKAGE_RESTART", "android.intent.action.RADIO_TECHNOLOGY", "android.intent.action.REBOOT", "android.intent.action.REQUEST_PERMISSION", "android.intent.action.SCREEN_OFF", "android.intent.action.SCREEN_ON", "android.intent.action.SERVICE_STATE", "android.intent.action.SIG_STR", "android.intent.action.SIM_STATE_CHANGED", "android.intent.action.SUB_DEFAULT_CHANGED", "android.intent.action.TIMEZONE_CHANGED", "android.intent.action.TIME_SET", "android.intent.action.TIME_TICK", "android.intent.action.UID_REMOVED", "android.intent.action.USER_ADDED", "android.intent.action.USER_BACKGROUND", "android.intent.action.USER_FOREGROUND", "android.intent.action.USER_PRESENT", "android.intent.action.USER_REMOVED", "android.intent.action.USER_STARTED", "android.intent.action.USER_STARTING", "android.intent.action.USER_STOPPED", "android.intent.action.USER_STOPPING", "android.intent.action.USER_SWITCHED", "android.location.GPS_ENABLED_CHANGE", "android.location.GPS_FIX_CHANGE", "android.location.MODE_CHANGED", "android.location.PROVIDERS_CHANGED", "android.media.ACTION_SCO_AUDIO_STATE_UPDATED", "android.media.AUDIO_BECOMING_NOISY", "android.media.MASTER_MUTE_CHANGED_ACTION", "android.media.MASTER_VOLUME_CHANGED_ACTION", "android.media.RINGER_MODE_CHANGED", "android.media.SCO_AUDIO_STATE_CHANGED", "android.media.VIBRATE_SETTING_CHANGED", "android.media.VOLUME_CHANGED_ACTION", "android.media.action.ANALOG_AUDIO_DOCK_PLUG", "android.media.action.DIGITAL_AUDIO_DOCK_PLUG", "android.media.action.HDMI_AUDIO_PLUG", "android.media.action.USB_AUDIO_ACCESSORY_PLUG", "android.media.action.USB_AUDIO_DEVICE_PLUG", "android.net.ConnectivityService.action.PKT_CNT_SAMPLE_INTERVAL_ELAPSED", "android.net.conn.BACKGROUND_DATA_SETTING_CHANGED", "android.net.conn.CAPTIVE_PORTAL_TEST_COMPLETED", "android.net.conn.CONNECTIVITY_CHANGE", "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE", "android.net.conn.DATA_ACTIVITY_CHANGE", "android.net.conn.INET_CONDITION_ACTION", "android.net.conn.NETWORK_CONDITIONS_MEASURED", "android.net.conn.TETHER_STATE_CHANGED", "android.net.nsd.STATE_CHANGED", "android.net.proxy.PAC_REFRESH", "android.net.scoring.SCORER_CHANGED", "android.net.scoring.SCORE_NETWORKS", "android.net.wifi.CONFIGURED_NETWORKS_CHANGE", "android.net.wifi.LINK_CONFIGURATION_CHANGED", "android.net.wifi.RSSI_CHANGED", "android.net.wifi.SCAN_RESULTS", "android.net.wifi.STATE_CHANGE", "android.net.wifi.WIFI_AP_STATE_CHANGED", "android.net.wifi.WIFI_SCAN_AVAILABLE", "android.net.wifi.WIFI_STATE_CHANGED", "android.net.wifi.p2p.CONNECTION_STATE_CHANGE", "android.net.wifi.p2p.DISCOVERY_STATE_CHANGE", "android.net.wifi.p2p.PEERS_CHANGED", "android.net.wifi.p2p.PERSISTENT_GROUPS_CHANGED", "android.net.wifi.p2p.STATE_CHANGED", "android.net.wifi.p2p.THIS_DEVICE_CHANGED", "android.net.wifi.supplicant.CONNECTION_CHANGE", "android.net.wifi.supplicant.STATE_CHANGE", "android.nfc.action.LLCP_LINK_STATE_CHANGED", "android.nfc.action.TRANSACTION_DETECTED", "android.nfc.handover.intent.action.HANDOVER_STARTED", "android.nfc.handover.intent.action.TRANSFER_DONE", "android.nfc.handover.intent.action.TRANSFER_DONE", "android.nfc.handover.intent.action.TRANSFER_PROGRESS", "android.os.UpdateLock.UPDATE_LOCK_CHANGED", "android.os.action.POWER_SAVE_MODE_CHANGED", "android.os.action.POWER_SAVE_MODE_CHANGING", "android.provider.Telephony.SIM_FULL", "android.provider.Telephony.SPN_STRINGS_UPDATED", "com.android.bluetooth.pbap.authcancelled", "com.android.bluetooth.pbap.authchall", "com.android.bluetooth.pbap.authresponse", "com.android.bluetooth.pbap.userconfirmtimeout", "com.android.internal.telephony.data-restart-trysetup", "com.android.internal.telephony.data-stall", "com.android.nfc_extras.action.AID_SELECTED", "com.android.nfc_extras.action.RF_FIELD_OFF_DETECTED", "com.android.nfc_extras.action.RF_FIELD_ON_DETECTED", "com.android.server.WifiManager.action.DELAYED_DRIVER_STOP", "com.android.server.WifiManager.action.START_SCAN", "com.android.server.connectivityservice.CONNECTED_TO_PROVISIONING_NETWORK_ACTION"};
    private static final Set<String> PROTECTED_BROADCAST_SET = new HashSet<String>(Arrays.asList(PROTECTED_BROADCASTS));
    private Set<String> mReceiversWithProtectedBroadcastIntentFilter = new HashSet<String>();

    public Speed getSpeed() {
        return Speed.SLOW;
    }

    public void checkClass(ClassContext context, ClassNode classNode) {
        if (!this.mReceiversWithProtectedBroadcastIntentFilter.contains(classNode.name)) {
            return;
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            if (!"onReceive".equals(method.name) || !"(Landroid/content/Context;Landroid/content/Intent;)V".equals(method.desc)) continue;
            boolean getActionEncountered = false;
            boolean intentParameterEncountered = false;
            InsnList nodes = method.instructions;
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                VarInsnNode node;
                AbstractInsnNode instruction = nodes.get(i);
                int type = instruction.getType();
                if (type == 2) {
                    node = (VarInsnNode)instruction;
                    if (node.getOpcode() != 25 || node.var != 2) continue;
                    intentParameterEncountered = true;
                    continue;
                }
                if (type != 5) continue;
                node = (MethodInsnNode)instruction;
                if (!"android/content/Intent".equals(node.owner) || !"getAction".equals(node.name)) continue;
                getActionEncountered = true;
                break;
            }
            if (getActionEncountered) continue;
            Location location = context.getLocation(method, classNode);
            String report = !intentParameterEncountered ? "This broadcast receiver declares an intent-filter for a protected broadcast action string, which can only be sent by the system, not third-party applications. However, the receiver's onReceive method does not appear to call getAction to ensure that the received Intent's action string matches the expected value, potentially making it possible for another actor to send a spoofed intent with no action string or a different action string and cause undesired behavior." : "This broadcast receiver declares an intent-filter for a protected broadcast action string, which can only be sent by the system, not third-party applications. However, the receiver's onReceive method does not appear to call getAction to ensure that the received Intent's action string matches the expected value, potentially making it possible for another actor to send a spoofed intent with no action string or a different action string and cause undesired behavior. In this case, it is possible that the onReceive method passed the received Intent to another method that checked the action string. If so, this finding can safely be ignored.";
            context.report(ACTION_STRING, method, null, location, report);
        }
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("receiver");
    }

    public void visitElement(XmlContext context, Element element) {
        String tag = element.getTagName();
        if ("receiver".equals(tag)) {
            String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            String permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
            if (permission == null || permission.isEmpty()) {
                Element parent = (Element)element.getParentNode();
                permission = parent.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
            }
            List children = LintUtils.getChildren((Node)element);
            for (Element child : children) {
                String tagName = child.getTagName();
                if (!"intent-filter".equals(tagName)) continue;
                if (name.startsWith(".")) {
                    name = context.getProject().getPackage() + name;
                }
                name = name.replace('.', '/');
                List children2 = LintUtils.getChildren((Node)child);
                for (Element child2 : children2) {
                    if (!"action".equals(child2.getTagName())) continue;
                    String actionName = child2.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (("android.provider.Telephony.SMS_DELIVER".equals(actionName) || "android.provider.Telephony.SMS_RECEIVED".equals(actionName)) && !"android.permission.BROADCAST_SMS".equals(permission)) {
                        context.report(BROADCAST_SMS, (Node)element, context.getLocation((Node)element), "BroadcastReceivers that declare an intent-filter for SMS_DELIVER or SMS_RECEIVED must ensure that the caller has the BROADCAST_SMS permission, otherwise it is possible for malicious actors to spoof intents.");
                        continue;
                    }
                    if (!PROTECTED_BROADCAST_SET.contains(actionName)) continue;
                    this.mReceiversWithProtectedBroadcastIntentFilter.add(name);
                }
            }
        }
    }
}

